/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.difftool.DiffRenderer;
import de.skuzzle.difftool.SplitDiffRenderer;
import de.skuzzle.difftool.UnifiedDiffRenderer;
import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestOptions;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.NormalizeLineEndingsSnapshotSerializer;
import de.skuzzle.test.snapshots.impl.ResultRecorder;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionInput;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

final class SnapshotDslResult {
    private static final String UNAVAILABLE_BECAUSE_ACTUAL_WAS_NULL = "<<unavailable because actual was null>>";
    private final SnapshotConfiguration configuration;
    private final ResultRecorder resultRecorder;
    private final Method testMethod;
    private final SnapshotNaming namingStrategy;
    private final SnapshotSerializer snapshotSerializer;
    private final SnapshotAssertionInput.TerminalOperation operation;
    private final Path directoryOverride;
    private final Object actual;

    SnapshotDslResult(SnapshotConfiguration configuration, ResultRecorder resultRecorder, Method testMethod, SnapshotNaming namingStrategy, Object actual, SnapshotAssertionInput.TerminalOperation operation, SnapshotSerializer snapshotSerializer, Path directoryOverride) {
        this.configuration = (SnapshotConfiguration)Arguments.requireNonNull((Object)configuration, (String)"configuration must not be null");
        this.resultRecorder = (ResultRecorder)Arguments.requireNonNull((Object)resultRecorder, (String)"resultRecorder must not be null");
        this.testMethod = (Method)Arguments.requireNonNull((Object)testMethod, (String)"testMethod must not be null");
        this.namingStrategy = (SnapshotNaming)Arguments.requireNonNull((Object)namingStrategy, (String)"namingStrategy must not be null");
        this.operation = (SnapshotAssertionInput.TerminalOperation)((Object)Arguments.requireNonNull((Object)((Object)operation), (String)"operation must not be null"));
        this.snapshotSerializer = (SnapshotSerializer)Arguments.requireNonNull((Object)snapshotSerializer, (String)"snapshotSerializer must not be null");
        this.directoryOverride = directoryOverride;
        this.actual = actual;
    }

    private SnapshotFile.SnapshotHeader determineNextSnapshotHeader(String snapshotName, int snapshotNumber) {
        return SnapshotFile.SnapshotHeader.fromMap(Map.of("snapshot-number", "" + snapshotNumber, "test-method", this.testMethod.getName(), "test-class", this.configuration.testClass().getName(), "snapshot-name", snapshotName, "dynamic-directory", "" + (this.directoryOverride != null)));
    }

    private Path determineSnapshotDirectory() throws IOException {
        Path snapshotDirectory = this.directoryOverride != null ? this.directoryOverride : this.configuration.determineSnapshotDirectory();
        Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
        return snapshotDirectory;
    }

    private ContextFiles determineContextFiles(Path snapshotDirectory, String snapshotName) throws IOException {
        String snapshotFileName = InternalSnapshotNaming.getSnapshotFileName(snapshotName);
        String actualFileName = InternalSnapshotNaming.getSnapshotFileNameActual(snapshotName);
        String rawFileName = InternalSnapshotNaming.getSnapshotFileNameRaw(snapshotName);
        return ContextFiles.of(snapshotDirectory.resolve(snapshotFileName), snapshotDirectory.resolve(actualFileName), snapshotDirectory.resolve(rawFileName));
    }

    private DiffRenderer determineDiffRenderer(SnapshotTestOptions.DiffFormat diffFormat) {
        switch (diffFormat) {
            case UNIFIED: {
                return UnifiedDiffRenderer.INSTANCE;
            }
            case SPLIT: {
                return SplitDiffRenderer.INSTANCE;
            }
        }
        throw new IllegalStateException("Unhandled DiffFormat constant: " + diffFormat);
    }

    SnapshotAssertionInput createAssertionInput() throws Exception {
        String serializedActual;
        boolean actualWasNull;
        int snapshotNumber = this.resultRecorder.size();
        Path snapshotDirectory = this.determineSnapshotDirectory();
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, snapshotNumber);
        ContextFiles contextFilePaths = this.determineContextFiles(snapshotDirectory, snapshotName);
        boolean disableAssertion = this.operation == SnapshotAssertionInput.TerminalOperation.DISABLE;
        boolean forceUpdateSnapshots = this.configuration.isForceUpdateSnapshots(this.testMethod) || this.operation == SnapshotAssertionInput.TerminalOperation.FORCE_UPDATE;
        boolean snapshotFileAlreadyExists = Files.exists(contextFilePaths.snapshotFile(), new LinkOption[0]);
        boolean alwaysPersistActualResult = this.configuration.alwaysPersistActualResult(this.testMethod);
        boolean alwaysPersistRawResult = this.configuration.alwaysPersistRawResult(this.testMethod);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName, snapshotNumber);
        boolean bl = actualWasNull = this.actual == null;
        if (actualWasNull) {
            serializedActual = UNAVAILABLE_BECAUSE_ACTUAL_WAS_NULL;
        } else {
            SnapshotTestOptions.NormalizeLineEndings normalizeLineEndings = this.configuration.normalizeLineEndings(this.testMethod);
            SnapshotSerializer normalizingSerializer = NormalizeLineEndingsSnapshotSerializer.wrap(this.snapshotSerializer, normalizeLineEndings);
            serializedActual = normalizingSerializer.serialize(this.actual);
        }
        SnapshotFile actualSnapshotFile = SnapshotFile.of(snapshotHeader, serializedActual);
        int lineNumberOffset = this.configuration.addOffsetToReportedLinenumbers(this.testMethod) ? snapshotHeader.lineNumberOffset() : 0;
        int contextLines = this.configuration.textDiffContextLines(this.testMethod);
        DiffRenderer diffRenderer = this.determineDiffRenderer(this.configuration.diffFormat(this.testMethod));
        boolean softAssertions = this.configuration.isSoftAssertions();
        return new SnapshotAssertionInput(snapshotName, contextFilePaths, actualSnapshotFile, softAssertions, actualWasNull, disableAssertion, forceUpdateSnapshots, snapshotFileAlreadyExists, alwaysPersistActualResult, alwaysPersistRawResult, lineNumberOffset, contextLines, diffRenderer);
    }
}

