/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.Snapshot;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.TextSnapshot;
import de.skuzzle.test.snapshots.impl.DefaultExecutionLifecycle;
import de.skuzzle.test.snapshots.impl.DslState;
import de.skuzzle.test.snapshots.impl.ResultRecorder;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionExecutor;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionInput;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotDslResult;
import de.skuzzle.test.snapshots.validation.Arguments;
import de.skuzzle.test.snapshots.validation.State;
import java.lang.reflect.Method;
import java.nio.file.Path;

final class SnapshotDslImpl
implements Snapshot,
SnapshotDsl.ChooseActual,
SnapshotDsl.ChooseDataFormat,
SnapshotDsl.ChooseStructure,
SnapshotDsl.ChooseAssertions {
    private final ResultRecorder resultRecorder;
    private final SnapshotConfiguration snapshotConfiguration;
    private final Method testMethod;
    private final DslState state = DslState.initial();
    private Object actual;
    private Path directoryOverride;
    private SnapshotNaming namingStrategy;
    private SnapshotSerializer snapshotSerializer;
    private StructuralAssertions structuralAssertions;

    public SnapshotDslImpl(ResultRecorder resultRecorder, SnapshotConfiguration snapshotConfiguration, Method testMethod) {
        this.resultRecorder = (ResultRecorder)Arguments.requireNonNull((Object)resultRecorder, (String)"resultRecorder must not be null");
        this.snapshotConfiguration = (SnapshotConfiguration)Arguments.requireNonNull((Object)snapshotConfiguration, (String)"snapshotConfiguration must not be null");
        this.testMethod = (Method)Arguments.requireNonNull((Object)testMethod, (String)"testMethod must not be null");
        this.resetDSL();
    }

    private void resetDSL() {
        this.state.reset();
        this.actual = null;
        this.directoryOverride = null;
        this.namingStrategy = SnapshotNaming.defaultNaming();
        this.snapshotSerializer = TextSnapshot.text.snapshotSerializer();
        this.structuralAssertions = TextSnapshot.text.structuralAssertions();
    }

    @Override
    public SnapshotDsl.ChooseActual namedAccordingTo(SnapshotNaming namingStrategy) {
        this.state.append(2);
        this.namingStrategy = (SnapshotNaming)Arguments.requireNonNull((Object)namingStrategy, (String)"namingStrategy must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseName in(Path directory) {
        this.state.append(8);
        this.directoryOverride = (Path)Arguments.requireNonNull((Object)directory, (String)"directory must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseDataFormat assertThat(Object actual) {
        this.state.append(4);
        this.actual = actual;
        return this;
    }

    @Override
    public SnapshotDsl.ChooseAssertions asText() {
        return this.as(TextSnapshot.text);
    }

    @Override
    public SnapshotDsl.ChooseAssertions as(SnapshotSerializer serializer) {
        this.state.append(16);
        this.snapshotSerializer = (SnapshotSerializer)Arguments.requireNonNull((Object)serializer, (String)"serializer must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseStructure as(StructuredDataProvider structuredDataBuilder) {
        this.state.append(32);
        this.state.append(16);
        StructuredData structure = ((StructuredDataProvider)Arguments.requireNonNull((Object)structuredDataBuilder, (String)"structuredDataBuilder must not be null")).build();
        this.snapshotSerializer = structure.snapshotSerializer();
        this.structuralAssertions = structure.structuralAssertions();
        return this;
    }

    private boolean isCustomTextSnapshot() {
        return this.structuralAssertions.getClass().equals(TextSnapshot.text.structuralAssertions().getClass());
    }

    @Override
    public SnapshotTestResult matchesSnapshotText() {
        if (this.isCustomTextSnapshot()) {
            return this.matchesAccordingTo(this.structuralAssertions);
        }
        return this.matchesAccordingTo(TextSnapshot.text.structuralAssertions());
    }

    @Override
    public SnapshotTestResult matchesSnapshotStructure() {
        return this.matchesAccordingTo(this.structuralAssertions);
    }

    @Override
    public SnapshotTestResult matchesAccordingTo(StructuralAssertions structuralAssertions) {
        Arguments.requireNonNull((Object)structuralAssertions, (String)"structuralAssertions must not be null");
        return this.terminal(SnapshotAssertionInput.TerminalOperation.ASSERT, structuralAssertions);
    }

    @Override
    public SnapshotTestResult justUpdateSnapshot() {
        return this.terminal(SnapshotAssertionInput.TerminalOperation.FORCE_UPDATE, this.structuralAssertions);
    }

    @Override
    public SnapshotTestResult disabled() {
        return this.terminal(SnapshotAssertionInput.TerminalOperation.DISABLE, this.structuralAssertions);
    }

    @Override
    public SnapshotTestResult disabledBecause(String message) {
        return this.terminal(SnapshotAssertionInput.TerminalOperation.DISABLE, this.structuralAssertions);
    }

    private SnapshotTestResult terminal(SnapshotAssertionInput.TerminalOperation operation, StructuralAssertions structuralAssertions) {
        try {
            SnapshotDslResult dslResult = new SnapshotDslResult(this.snapshotConfiguration, this.resultRecorder, this.testMethod, this.namingStrategy, this.actual, operation, this.snapshotSerializer, this.directoryOverride);
            SnapshotAssertionInput assertionInput = dslResult.createAssertionInput();
            SnapshotAssertionExecutor assertionExecutor = new SnapshotAssertionExecutor();
            DefaultExecutionLifecycle lifecycle = new DefaultExecutionLifecycle(assertionExecutor, this.resultRecorder);
            SnapshotTestResult snapshotTestResult = lifecycle.executeLifecycleWith(structuralAssertions, assertionInput);
            return snapshotTestResult;
        }
        catch (Exception e) {
            throw new SnapshotException("Technical problem while performing snapshot test terminal operation", e);
        }
        finally {
            this.resetDSL();
        }
    }

    void executeFinalAssertions() throws Exception {
        State.check((boolean)this.state.isInitial(), (String)"Detected incomplete DSL usage. Please always call a terminal operation (see JavaDoc of the Snapshot class for details). If you want to temporarily disable a snapshot assertion, use the disabled() terminal operation.", (Object[])new Object[0]);
        this.resultRecorder.throwIfNotSuccessfulOrCreatedInitiallyOrUpdatedForcefully(this.snapshotConfiguration.isSoftAssertions());
    }
}

