/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotTestOptions;
import de.skuzzle.test.snapshots.impl.DefaultSnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.LegacySnapshotConfiguration;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.1.0")
public interface SnapshotConfiguration {
    @API(status=API.Status.INTERNAL, since="1.7.0")
    public static SnapshotConfiguration defaultConfigurationFor(Class<?> testClass) {
        return DefaultSnapshotConfiguration.forTestClass(testClass);
    }

    @Deprecated(since="1.7.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public static SnapshotConfiguration legacyConfigurationFor(Class<?> testClass) {
        return LegacySnapshotConfiguration.forTestClass(testClass);
    }

    public Path determineSnapshotDirectory();

    public Class<?> testClass();

    @API(status=API.Status.INTERNAL, since="1.7.0")
    public boolean alwaysPersistActualResult(Method var1);

    @API(status=API.Status.INTERNAL, since="1.7.0")
    public boolean alwaysPersistRawResult(Method var1);

    @API(status=API.Status.INTERNAL, since="1.7.0")
    public int textDiffContextLines(Method var1);

    @API(status=API.Status.INTERNAL, since="1.7.1")
    public boolean addOffsetToReportedLinenumbers(Method var1);

    public boolean isDeleteOrphanedSnapshots();

    public boolean isForceUpdateSnapshots(Method var1);

    @API(since="1.10.0", status=API.Status.INTERNAL)
    public SnapshotTestOptions.NormalizeLineEndings normalizeLineEndings(Method var1);

    @API(status=API.Status.INTERNAL, since="1.10.0")
    public SnapshotTestOptions.DiffFormat diffFormat(Method var1);

    @Deprecated(since="1.7.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public boolean isSoftAssertions();
}

