/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.difftool.LineSeparator;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestOptions;
import de.skuzzle.test.snapshots.validation.Arguments;

final class NormalizeLineEndingsSnapshotSerializer
implements SnapshotSerializer {
    private final SnapshotSerializer delegate;
    private final SnapshotTestOptions.NormalizeLineEndings normalizeLineEndings;

    private NormalizeLineEndingsSnapshotSerializer(SnapshotSerializer delegate, SnapshotTestOptions.NormalizeLineEndings normalizeLineEndings) {
        this.delegate = (SnapshotSerializer)Arguments.requireNonNull((Object)delegate, (String)"delegate serializer must not be null");
        this.normalizeLineEndings = (SnapshotTestOptions.NormalizeLineEndings)((Object)Arguments.requireNonNull((Object)((Object)normalizeLineEndings), (String)"normalizeLineEndings must not be null"));
    }

    static SnapshotSerializer wrap(SnapshotSerializer serializer, SnapshotTestOptions.NormalizeLineEndings normalizeLineEndings) {
        return new NormalizeLineEndingsSnapshotSerializer(serializer, normalizeLineEndings);
    }

    @Override
    public String serialize(Object testResult) throws SnapshotException {
        String result = this.delegate.serialize(testResult);
        if (this.normalizeLineEndings == SnapshotTestOptions.NormalizeLineEndings.NEVER) {
            return result;
        }
        LineSeparator lineSeparator = this.determineLineSeparator();
        return lineSeparator.convert(result);
    }

    private LineSeparator determineLineSeparator() {
        switch (this.normalizeLineEndings) {
            case SYSTEM: {
                return LineSeparator.SYSTEM;
            }
            case CRLF: {
                return LineSeparator.CRLF;
            }
            case LF: {
                return LineSeparator.LF;
            }
            case GIT: {
                return LineSeparator.determineFromGitConfig();
            }
        }
        throw new IllegalStateException("Could not determine LineSeparator for: " + this.normalizeLineEndings);
    }
}

