/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.SnapshotDslResult;
import de.skuzzle.test.snapshots.impl.Throwables;
import de.skuzzle.test.snapshots.reflection.StackTraces;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class LocalResultCollector {
    private final List<SnapshotTestResult> results = new ArrayList<SnapshotTestResult>();
    private final Function<String, Throwable> assumptionFailedConstructor;

    LocalResultCollector(Function<String, Throwable> assumptionFailedConstructor) {
        this.assumptionFailedConstructor = assumptionFailedConstructor;
    }

    public void recordSnapshotTestResult(SnapshotTestResult result) {
        this.results.add((SnapshotTestResult)Arguments.requireNonNull((Object)result));
    }

    public int size() {
        return this.results.size();
    }

    public void throwIfNotSuccessfulOrCreatedInitiallyOrUpdatedForcefully(boolean softAssertions) throws Exception {
        Throwable failures = null;
        if (softAssertions) {
            failures = Throwables.flattenThrowables(this.results.stream().map(SnapshotTestResult::failure).flatMap(Optional::stream));
        }
        failures = Throwables.combine(failures, this.failIfCreatedInitially());
        failures = Throwables.combine(failures, this.failIfUpdatedForcefully());
        failures = Throwables.combine(failures, this.abortIfNoneFailedAndAtLeastOneWasDisabled());
        String internalPackage = SnapshotDslResult.class.getPackageName();
        StackTraces.filterStackTrace((Throwable)failures, element -> element.getClassName().startsWith(internalPackage));
        Throwables.throwIfNotNull(failures);
    }

    public void throwIfNotSuccessful() throws Exception {
        Throwable failures = Throwables.flattenThrowables(this.results.stream().map(SnapshotTestResult::failure).flatMap(Optional::stream));
        String internalPackage = SnapshotDslResult.class.getPackageName();
        StackTraces.filterStackTrace((Throwable)failures, element -> element.getClassName().startsWith(internalPackage));
        Throwables.throwIfNotNull(failures);
    }

    private Throwable failIfCreatedInitially() {
        if (this.wasAnyCreatedInitially()) {
            String createdSnapshotFilePaths = this.results.stream().filter(result -> result.status() == SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY).map(SnapshotTestResult::contextFiles).map(ContextFiles::snapshotFile).map(Path::toString).collect(Collectors.joining(System.lineSeparator()));
            return new AssertionError((Object)String.format("Snapshots have been created the first time.%nRun the test again and you should see it succeed.%n%nCreated snapshot files:%n%s", createdSnapshotFilePaths));
        }
        return null;
    }

    private Throwable failIfUpdatedForcefully() {
        if (this.wasAnyUpdatedForcefully()) {
            return new AssertionError((Object)String.format("Snapshots have been updated forcefully.%nRemove '@ForceUpdateSnapshots' annotation from your test class and calls to 'justUpdateSnapshot()' then run the tests again.", new Object[0]));
        }
        return null;
    }

    private Throwable abortIfNoneFailedAndAtLeastOneWasDisabled() {
        if (this.wasAtLeastOneDisabledAndAllOthersSuccessful()) {
            return this.assumptionFailedConstructor.apply("Assertion was disabled");
        }
        return null;
    }

    private boolean wasAtLeastOneDisabledAndAllOthersSuccessful() {
        boolean atLeastOneDisabled = this.results.stream().map(SnapshotTestResult::status).anyMatch(SnapshotTestResult.SnapshotStatus.DISABLED::equals);
        boolean noFailed = this.results.stream().map(SnapshotTestResult::failure).noneMatch(Optional::isPresent);
        return atLeastOneDisabled && noFailed && !this.wasAnyCreatedInitially() && !this.wasAnyUpdatedForcefully();
    }

    private boolean wasAnyCreatedInitially() {
        return this.results.stream().map(SnapshotTestResult::status).anyMatch(SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY::equals);
    }

    private boolean wasAnyUpdatedForcefully() {
        return this.results.stream().map(SnapshotTestResult::status).anyMatch(SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY::equals);
    }
}

