/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDirectory;
import de.skuzzle.test.snapshots.SnapshotDirectoryStrategy;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.impl.TestClass;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import de.skuzzle.test.snapshots.validation.State;
import java.nio.file.Path;

final class DetermineSnapshotDirectory {
    static Path forTestclass(TestClass testClass) {
        Path testDirectoryLegacy = DetermineSnapshotDirectory.snapshotDirectoryLegacy(testClass.testClass());
        SnapshotDirectory annotation = testClass.getAnnotation(SnapshotDirectory.class);
        if (testDirectoryLegacy != null) {
            State.check((annotation == null ? 1 : 0) != 0, (String)"Please use either legacy mode of specifying snapshot directory or the new @SnapshotDirectory annotation but not both", (Object[])new Object[0]);
            return testDirectoryLegacy;
        }
        if (annotation == null) {
            String dirName = testClass.getName().replace('.', '/') + "_snapshots";
            return DirectoryResolver.resolve((String)dirName);
        }
        State.check((!DetermineSnapshotDirectory.isDefaultValue(annotation.determinedBy()) || !annotation.value().isEmpty() ? 1 : 0) != 0, (String)"Either specify the value() attribute or the determinedBy() attribute within the @SnapshotDirectory annotation on %s", (Object[])new Object[]{testClass.getName()});
        if (DetermineSnapshotDirectory.isDefaultValue(annotation.determinedBy())) {
            return DirectoryResolver.resolve((String)annotation.value());
        }
        return DetermineSnapshotDirectory.pathFromStrategy(testClass, annotation);
    }

    private static boolean isDefaultValue(Class<?> type) {
        return "de.skuzzle.test.snapshots.DefaultSnapshotDirectoryStrategy".equals(type.getName());
    }

    private static Path pathFromStrategy(TestClass testClass, SnapshotDirectory directory) {
        try {
            Path snapshotDirectory = DetermineSnapshotDirectory.newInstanceOf(directory.determinedBy()).determineSnapshotDirectory(testClass.testClass(), directory);
            State.check((snapshotDirectory != null ? 1 : 0) != 0, (String)"Custom SnapshotDirectoryStrategy %s returned null for %s", (Object[])new Object[]{directory.determinedBy().getName(), directory});
            return snapshotDirectory;
        }
        catch (SnapshotException e) {
            throw new IllegalStateException("Error determining snapshot directory from strategy " + directory.determinedBy(), e);
        }
    }

    private static SnapshotDirectoryStrategy newInstanceOf(Class<? extends SnapshotDirectoryStrategy> type) {
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating an instance of " + type.getName(), e);
        }
    }

    private static Path snapshotDirectoryLegacy(Class<?> testClass) {
        EnableSnapshotTests snapshotAssertions = testClass.getAnnotation(EnableSnapshotTests.class);
        if (snapshotAssertions == null || snapshotAssertions.snapshotDirectory().isEmpty()) {
            return null;
        }
        String testDirName = snapshotAssertions.snapshotDirectory();
        return DirectoryResolver.resolve((String)testDirName);
    }

    private DetermineSnapshotDirectory() {
    }
}

