/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.impl.ExecutionLifecycle;
import de.skuzzle.test.snapshots.impl.ResultRecorder;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionExecutor;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

final class DefaultExecutionLifecycle
implements ExecutionLifecycle {
    private final SnapshotAssertionExecutor assertionExecutor;
    private final ResultRecorder resultRecorder;

    DefaultExecutionLifecycle(SnapshotAssertionExecutor assertionExecutor, ResultRecorder resultRecorder) {
        this.resultRecorder = resultRecorder;
        this.assertionExecutor = assertionExecutor;
    }

    @Override
    public SnapshotTestResult executeAssertion(SnapshotAssertionInput assertionInput, StructuralAssertions structuralAssertions) throws Exception {
        return this.assertionExecutor.execute(structuralAssertions, assertionInput);
    }

    @Override
    public void beforeExecution(SnapshotAssertionInput assertionInput) throws Exception {
        if (!this.decideAcceptNullAsActual(assertionInput) && assertionInput.actualWasNull()) {
            throw new AssertionError((Object)"Expected actual not to be null in order to take snapshot");
        }
        if (this.decideWriteContextFiles(assertionInput)) {
            this.writeAdditionalContextFiles(assertionInput);
        }
    }

    @Override
    public void afterExecution(SnapshotAssertionInput assertionInput, SnapshotTestResult result) throws Exception {
        this.resultRecorder.recordSnapshotTestResult(result);
        if (this.decideUpdateHeader(assertionInput, result)) {
            this.updatePersistedSnapshotHeader(assertionInput, result);
        }
        if (this.decideUpdatePersistedSnapshot(result)) {
            this.updatePersistedSnapshot(assertionInput);
        }
        if (!assertionInput.isSoftAssertions()) {
            this.resultRecorder.throwIfNotSuccessful();
        }
    }

    private boolean decideAcceptNullAsActual(SnapshotAssertionInput assertionInput) {
        return assertionInput.isDisableAssertion();
    }

    private boolean decideWriteContextFiles(SnapshotAssertionInput assertionInput) {
        return !assertionInput.isDisableAssertion();
    }

    private boolean decideUpdateHeader(SnapshotAssertionInput assertionInput, SnapshotTestResult result) {
        return assertionInput.isSnapshotFileAlreadyExists() && !assertionInput.actualSnapshotFile().header().equals(result.snapshotFile().header());
    }

    private void updatePersistedSnapshotHeader(SnapshotAssertionInput assertionInput, SnapshotTestResult result) throws IOException {
        Path snapshotFilePath = assertionInput.contextFiles().snapshotFile();
        result.snapshotFile().changeHeader(assertionInput.actualSnapshotFile().header()).writeTo(snapshotFilePath);
    }

    private void writeAdditionalContextFiles(SnapshotAssertionInput assertionInput) throws IOException {
        SnapshotFile snapshotFile = assertionInput.actualSnapshotFile();
        Path latestActualSnapshotFile = assertionInput.contextFiles().actualResultFile();
        if (assertionInput.alwaysPersistActualResult()) {
            snapshotFile.writeTo(latestActualSnapshotFile);
        } else {
            Files.deleteIfExists(latestActualSnapshotFile);
        }
        Path rawSnapshotFile = assertionInput.contextFiles().rawActualResultFile();
        if (assertionInput.isAlwaysPersistRawResult()) {
            Files.writeString(rawSnapshotFile, (CharSequence)snapshotFile.snapshot(), StandardCharsets.UTF_8, new OpenOption[0]);
        } else {
            Files.deleteIfExists(rawSnapshotFile);
        }
    }

    private boolean decideUpdatePersistedSnapshot(SnapshotTestResult result) {
        switch (result.status()) {
            case CREATED_INITIALLY: 
            case UPDATED_FORCEFULLY: {
                return true;
            }
        }
        return false;
    }

    private void updatePersistedSnapshot(SnapshotAssertionInput assertionInput) throws IOException {
        Path snapshotFilePath = assertionInput.contextFiles().snapshotFile();
        assertionInput.actualSnapshotFile().writeTo(snapshotFilePath);
    }
}

