/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import de.skuzzle.difftool.DiffAlgorithm;
import de.skuzzle.difftool.DiffRenderer;
import de.skuzzle.difftool.DiffSettings;
import de.skuzzle.difftool.LineSeparator;
import de.skuzzle.difftool.StringDiff;
import de.skuzzle.difftool.UnifiedDiffRenderer;
import de.skuzzle.difftool.thirdparty.DiffUtilsDiffAlgorithm;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.4.0")
public final class TextDiff {
    private final Settings settings;
    private final StringDiff diff;

    private TextDiff(Settings settings, StringDiff diff) {
        this.settings = settings;
        this.diff = diff;
    }

    public static TextDiff compare(Settings settings, String expected, String actual) {
        Arguments.requireNonNull((Object)(settings != null ? 1 : 0), (String)"settings must not be null");
        Arguments.requireNonNull((Object)expected, (String)"expected String must not be null");
        Arguments.requireNonNull((Object)actual, (String)"actual String must not be null");
        StringDiff diff = StringDiff.using((DiffAlgorithm)DiffUtilsDiffAlgorithm.create(settings.buildDiffRowGenerator()), (String)expected, (String)actual);
        return new TextDiff(settings, diff);
    }

    private boolean hasLinebreakDifference() {
        return this.diff.hasLineSeparatorDifference() && !this.settings.ignoreWhitespaces;
    }

    private boolean hasTextDifference() {
        return this.diff.hasTextDifference();
    }

    public boolean differencesDetected() {
        return this.hasLinebreakDifference() || this.hasTextDifference();
    }

    public String renderDiffWithOffsetAndContextLines(int lineNumberOffset, int contextLines) {
        StringBuilder result = new StringBuilder();
        boolean hasTextDifference = this.hasTextDifference();
        boolean hasSignificantLinebreakDifference = this.hasLinebreakDifference();
        if (hasSignificantLinebreakDifference) {
            LineSeparator expectedLineSeparator = this.diff.leftLineSeparator();
            LineSeparator actualLineSeparator = this.diff.rightLineSeparator();
            result.append("Strings differ in linebreaks. Expected: '").append(expectedLineSeparator.displayName()).append("', Actual encountered: '").append(actualLineSeparator.displayName()).append("'");
            if (hasTextDifference) {
                result.append(LineSeparator.SYSTEM).append(LineSeparator.SYSTEM);
            }
        }
        if (hasTextDifference) {
            result.append(this.diff.toString(this.settings.diffRenderer, DiffSettings.withDefaultSymbols((int)contextLines, (int)lineNumberOffset)));
        }
        return result.toString();
    }

    public String toString() {
        return this.renderDiffWithOffsetAndContextLines(0, this.settings.contextLines);
    }

    @API(status=API.Status.INTERNAL, since="1.7.0")
    public static final class Settings {
        private boolean ignoreWhitespaces = false;
        private int contextLines = 5;
        private String inlineOpeningChangeMarker = "<<";
        private String inlineClosingChangeMarker = ">>";
        private DiffRenderer diffRenderer = UnifiedDiffRenderer.INSTANCE;

        private Settings() {
        }

        public static Settings defaultSettings() {
            return new Settings();
        }

        public Settings withIgnoreWhitespaces(boolean ignoreWhitespaces) {
            this.ignoreWhitespaces = ignoreWhitespaces;
            return this;
        }

        public Settings withContextLines(int contextLines) {
            Arguments.check((contextLines >= 0 ? 1 : 0) != 0, (String)"contextLines must be a positive integer");
            this.contextLines = contextLines;
            return this;
        }

        public Settings withInlineOpeningChangeMarker(String inlineOpeningChangeMarker) {
            this.inlineOpeningChangeMarker = (String)Arguments.requireNonNull((Object)inlineOpeningChangeMarker, (String)"opening marker must not be null");
            return this;
        }

        public Settings withInlineClosingChangeMarker(String inlineClosingChangeMarker) {
            this.inlineClosingChangeMarker = (String)Arguments.requireNonNull((Object)inlineClosingChangeMarker, (String)"closing marker must not be null");
            return this;
        }

        public Settings withDiffRenderer(DiffRenderer renderer) {
            this.diffRenderer = (DiffRenderer)Arguments.requireNonNull((Object)renderer, (String)"renderer must not be null");
            return this;
        }

        private BiFunction<DiffRow.Tag, Boolean, String> inlineMarker() {
            return (tag, isOpening) -> {
                if (tag != DiffRow.Tag.CHANGE) {
                    return "";
                }
                return isOpening != false ? this.inlineOpeningChangeMarker : this.inlineClosingChangeMarker;
            };
        }

        Consumer<DiffRowGenerator.Builder> buildDiffRowGenerator() {
            return builder -> builder.showInlineDiffs(true).lineNormalizer(Function.identity()).inlineDiffByWord(true).ignoreWhiteSpaces(this.ignoreWhitespaces).newTag(this.inlineMarker()).oldTag(this.inlineMarker());
        }
    }
}

