/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class SnapshotTestResult {
    private final SnapshotFile snapshot;
    private final SnapshotStatus status;
    private final ContextFiles contextFiles;
    private final String serializedActual;
    private final Throwable failure;

    private SnapshotTestResult(ContextFiles contextFiles, SnapshotStatus status, SnapshotFile snapshotFile, String serializedActual, Throwable failure) {
        this.contextFiles = (ContextFiles)Arguments.requireNonNull((Object)contextFiles);
        this.status = (SnapshotStatus)((Object)Arguments.requireNonNull((Object)((Object)status)));
        this.snapshot = (SnapshotFile)Arguments.requireNonNull((Object)snapshotFile);
        this.serializedActual = (String)Arguments.requireNonNull((Object)serializedActual);
        this.failure = failure;
    }

    @API(status=API.Status.INTERNAL)
    public static SnapshotTestResult forFailedTest(ContextFiles contextFiles, SnapshotFile snapshotFile, String serializedActual, Throwable failure) {
        return new SnapshotTestResult(contextFiles, SnapshotStatus.ASSERTED, snapshotFile, serializedActual, (Throwable)Arguments.requireNonNull((Object)failure));
    }

    @API(status=API.Status.INTERNAL)
    public static SnapshotTestResult of(ContextFiles contextFiles, SnapshotStatus status, SnapshotFile snapshotFile, String serializedActual) {
        return new SnapshotTestResult(contextFiles, status, snapshotFile, serializedActual, null);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public ContextFiles contextFiles() {
        return this.contextFiles;
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    public Path targetFile() {
        return this.contextFiles.snapshotFile();
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    public Path actualResultFile() {
        return this.contextFiles.actualResultFile();
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    public Path rawActualResultFile() {
        return this.contextFiles.rawActualResultFile();
    }

    public SnapshotStatus status() {
        return this.status;
    }

    @Deprecated(since="1.7.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public SnapshotFile serializedSnapshot() {
        return this.snapshot;
    }

    public SnapshotFile snapshotFile() {
        return this.snapshot;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.0")
    public String serializedActual() {
        return this.serializedActual;
    }

    public Optional<Throwable> failure() {
        return Optional.ofNullable(this.failure);
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    public void deleteSnapshot() throws IOException {
        this.contextFiles.deleteFiles();
    }

    public String toString() {
        return "status=" + (Object)((Object)this.status) + ", targetFile=" + this.contextFiles.snapshotFile();
    }

    public static enum SnapshotStatus {
        CREATED_INITIALLY,
        UPDATED_FORCEFULLY,
        ASSERTED,
        DISABLED;

    }
}

