/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class SnapshotFile {
    private final SnapshotHeader header;
    private final String snapshot;

    private SnapshotFile(SnapshotHeader header, String snapshot) {
        this.header = (SnapshotHeader)Arguments.requireNonNull((Object)header, (String)"snapshot header must not be null");
        this.snapshot = (String)Arguments.requireNonNull((Object)snapshot, (String)"snapshot must not be null");
    }

    public static SnapshotFile of(SnapshotHeader header, String snapshot) {
        return new SnapshotFile(header, snapshot);
    }

    public static SnapshotFile fromSnapshotFile(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            SnapshotFile snapshotFile = SnapshotFile.readFrom(reader);
            return snapshotFile;
        }
    }

    public static SnapshotFile readFrom(BufferedReader reader) throws IOException {
        SnapshotHeader header = SnapshotHeader.readFrom(reader);
        StringWriter snapshot = new StringWriter();
        reader.transferTo(snapshot);
        return new SnapshotFile(header, snapshot.toString());
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.1")
    public SnapshotFile changeHeader(SnapshotHeader newHeader) {
        return new SnapshotFile(newHeader, this.snapshot);
    }

    public SnapshotHeader header() {
        return this.header;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public SnapshotFile writeTo(Path snapshotFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(snapshotFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.writeTo(writer);
        }
        return this;
    }

    void writeTo(Writer writer) throws IOException {
        this.header.writeTo(writer);
        writer.write(this.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.snapshot);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SnapshotFile && Objects.equals(this.header, ((SnapshotFile)obj).header) && Objects.equals(this.snapshot, ((SnapshotFile)obj).snapshot);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static final class SnapshotHeader {
        public static final String TEST_CLASS = "test-class";
        public static final String TEST_METHOD = "test-method";
        public static final String SNAPSHOT_NUMBER = "snapshot-number";
        public static final String SNAPSHOT_NAME = "snapshot-name";
        @API(status=API.Status.EXPERIMENTAL, since="1.2.2")
        public static final String DYNAMIC_DIRECTORY = "dynamic-directory";
        private final Map<String, String> values;

        private SnapshotHeader(Map<String, String> values) {
            values.forEach((key, value) -> {
                Arguments.check((key.indexOf(10) < 0 && key.indexOf(13) < 0 ? 1 : 0) != 0, (String)"Snapshot header key must not contain linebreaks but was '%s'='%s'", (Object[])new Object[]{key, value});
                Arguments.check((value.indexOf(10) < 0 && value.indexOf(13) < 0 ? 1 : 0) != 0, (String)"Snapshot header values must not contain linebreaks but was '%s'='%s'", (Object[])new Object[]{key, value});
            });
            this.values = Collections.unmodifiableMap(values);
        }

        public static SnapshotHeader fromMap(Map<String, String> values) {
            return new SnapshotHeader(Map.copyOf(values));
        }

        public static SnapshotHeader readFrom(BufferedReader reader) throws IOException {
            HashMap<String, String> values = new HashMap<String, String>();
            String line = reader.readLine();
            while (line != null && !line.isEmpty()) {
                String[] parts = line.split(":", 2);
                Arguments.check((parts.length == 2 ? 1 : 0) != 0, (String)("Header contains invalid line: " + line));
                String key = parts[0].trim();
                String value = parts[1].trim();
                String prev = values.put(key, value);
                Arguments.check((prev == null ? 1 : 0) != 0, (String)"Header contains duplicate key: '%s' with values '%s' and '%s'", (Object[])new Object[]{key, value, prev});
                line = reader.readLine();
            }
            return new SnapshotHeader(values);
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.7.1")
        public int lineNumberOffset() {
            return this.values.size() + 1;
        }

        public String getOrDefault(String key, String defaultValue) {
            String value = this.values.get(Arguments.requireNonNull((Object)key, (String)"key must not be null"));
            return value == null ? defaultValue : value;
        }

        public String get(String key) {
            String value = this.values.get(Arguments.requireNonNull((Object)key, (String)"key must not be null"));
            return (String)Arguments.requireNonNull((Object)value, (String)"No SnapshotHeader value for key '%s' among %s", (Object[])new Object[]{key, this.values});
        }

        public int getInt(String key) {
            return Integer.parseInt(this.get(key));
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.2.2")
        public boolean getBoolean(String key, boolean defaultValue) {
            return Boolean.parseBoolean(this.getOrDefault(key, "" + defaultValue));
        }

        private void writeTo(Writer writer) throws IOException {
            Iterable sortedEntries = this.values.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey))::iterator;
            for (Map.Entry entry : sortedEntries) {
                writer.write((String)entry.getKey() + ": " + (String)entry.getValue());
                writer.write("\n");
            }
            writer.write("\n");
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SnapshotHeader && Objects.equals(this.values, ((SnapshotHeader)obj).values);
        }

        public String toString() {
            return "SnapshotHeader" + this.values;
        }
    }
}

