/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.impl.MetaTest;
import de.skuzzle.test.snapshots.impl.MockSnapshotLoggerFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=DisplayNameGenerator.ReplaceUnderscores.class)
public class OrphanedSnapshotDetectionTest {
    private final MetaTest frameworkTest = new MetaTest();

    @AfterEach
    void uninstallMockLogger() {
        MockSnapshotLoggerFactory.uninstall();
    }

    @Test
    void orphaned_file_for_deleted_test_should_correctly_be_detected() throws Throwable {
        MockSnapshotLoggerFactory.MockSnapshotLogger logger = MockSnapshotLoggerFactory.install();
        this.frameworkTest.expectTestcase(TestCase.class);
        logger.assertContainsExactlyOneEventWhere(logEvent -> logEvent.hasLevel("warn") && logEvent.messageMatches(message -> message.startsWith("Found orphaned snapshot file.")) && logEvent.containsParamWhere(param -> param.toString().contains("testThatHasBeenDeleted_0.snapshot")));
    }

    @Test
    void orphaned_files_should_not_be_detected_for_failing_tests() throws Throwable {
        MockSnapshotLoggerFactory.MockSnapshotLogger logger = MockSnapshotLoggerFactory.install();
        this.frameworkTest.expectTestcase(TestCase.class);
        logger.assertContainsNoEventWhere(logEvent -> logEvent.containsParamWhere(param -> param.toString().contains("failingTestMethod.snapshot")));
    }

    @EnableSnapshotTests
    static class TestCase {
        TestCase() {
        }

        @Test
        void failingTestMethod(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            throw new RuntimeException();
        }
    }
}

