/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.impl.SnapshotLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.opentest4j.AssertionFailedError;

class MockSnapshotLoggerFactory
implements SnapshotLogging.SnapshotLoggerFactory {
    private MockSnapshotLoggerFactory() {
    }

    public MockSnapshotLogger getLogger(Class<?> type) {
        return MockSnapshotLogger.INSTANCE;
    }

    public static MockSnapshotLogger install() {
        MockSnapshotLoggerFactory factory = new MockSnapshotLoggerFactory();
        SnapshotLogging.setFactory((SnapshotLogging.SnapshotLoggerFactory)factory);
        MockSnapshotLogger.INSTANCE.loggedMessages.clear();
        return MockSnapshotLogger.INSTANCE;
    }

    public static void uninstall() {
        SnapshotLogging.resetFactory();
    }

    public static final class LoggedMessage {
        private final String level;
        private final String message;
        private final Object[] params;

        private LoggedMessage(String level, String message, Object[] params) {
            this.level = level;
            this.message = message;
            this.params = params;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getParams() {
            return this.params;
        }

        public LoggedMessage assertMessageMatches(Consumer<AbstractStringAssert<?>> message) {
            AbstractStringAssert assertThat2 = Assertions.assertThat((String)this.message);
            message.accept(assertThat2);
            return this;
        }

        public boolean hasLevel(String level) {
            return level.equals(this.level);
        }

        public boolean containsParam(Object param) {
            return Arrays.asList(this.params).contains(param);
        }

        public boolean containsParamWhere(Predicate<Object> test) {
            return Arrays.stream(this.params).anyMatch(test);
        }

        public boolean messageMatches(Predicate<String> predicate) {
            return predicate.test(this.message);
        }

        public String toString() {
            return this.level + ": " + this.message + "\n" + Arrays.toString(this.params);
        }
    }

    public static final class MockSnapshotLogger
    implements SnapshotLogging.SnapshotLogger {
        private static final MockSnapshotLogger INSTANCE = new MockSnapshotLogger();
        private final List<LoggedMessage> loggedMessages = new ArrayList<LoggedMessage>();

        private MockSnapshotLogger() {
        }

        public List<LoggedMessage> getLoggedMessages() {
            return Collections.unmodifiableList(this.loggedMessages);
        }

        public LoggedMessage assertContainsExactlyOneEventWhere(Predicate<LoggedMessage> test) {
            List findings = this.loggedMessages.stream().filter(test).collect(Collectors.toList());
            if (findings.isEmpty()) {
                throw new AssertionFailedError("Expected to contain exactly one logged message with given predicate but none was found");
            }
            if (findings.size() > 1) {
                throw new AssertionFailedError("Expected to contain exactly one logged message with given predicate but found " + findings.size() + ":\n" + findings);
            }
            return (LoggedMessage)findings.get(0);
        }

        public void assertContainsNoEventWhere(Predicate<LoggedMessage> test) {
            this.loggedMessages.stream().filter(test).findFirst().ifPresent(event -> {
                throw new AssertionFailedError("Expected to contain no logged message with given predicate but at least one was found: \n" + event);
            });
        }

        public void info(String message, Object ... params) {
            this.loggedMessages.add(new LoggedMessage("info", message, params));
        }

        public void warn(String message, Object ... params) {
            this.loggedMessages.add(new LoggedMessage("warn", message, params));
        }
    }
}

