/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.testkit.engine.EngineExecutionResults;
import org.junit.platform.testkit.engine.EngineTestKit;
import org.junit.platform.testkit.engine.Execution;

class MetaTest {
    MetaTest() {
    }

    public TestResult expectTestcase(Class<?> testClass) {
        EngineExecutionResults executionResults = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(testClass)}).execute();
        return new TestResult(executionResults, testClass);
    }

    static void assumeMetaTest() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)MetaTest.containedInStacktrace()).as("This test cas will be executed as meta-test case", new Object[0])).isTrue();
    }

    private static boolean containedInStacktrace() {
        return StackWalker.getInstance().walk(stack -> stack.anyMatch(stackFrame -> stackFrame.getClassName().equals(MetaTest.class.getName()) && stackFrame.getMethodName().equals("expectTestcase")));
    }

    static class TestResult {
        private final EngineExecutionResults executionResults;

        private TestResult(EngineExecutionResults executionResults, Class<?> testClass) {
            this.executionResults = executionResults;
        }

        private Execution execution() {
            List executions = this.executionResults.testEvents().executions().list();
            if (executions.size() != 1) {
                throw new IllegalArgumentException("Expected a single execution but found: " + executions);
            }
            return (Execution)executions.get(0);
        }

        public void toSucceed() throws Throwable {
            Execution execution = this.execution();
            TestExecutionResult.Status status = execution.getTerminationInfo().getExecutionResult().getStatus();
            if (status != TestExecutionResult.Status.SUCCESSFUL) {
                throw (Throwable)execution.getTerminationInfo().getExecutionResult().getThrowable().get();
            }
        }

        public AbstractThrowableAssert<?, ? extends Throwable> toFailWithExceptionWhich() {
            Throwable throwable = (Throwable)this.execution().getTerminationInfo().getExecutionResult().getThrowable().orElseThrow(() -> new AssertionError((Object)"Expected test to throw an exception but none was thrown"));
            return Assertions.assertThat((Throwable)throwable);
        }
    }
}

