/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.MetaTest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class FailingSnapshotTests {
    @Test
    void testFailBecauseForceUpdateFromAnnotation() throws Throwable {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(FailBecauseForceUpdateFromAnnotation.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseJustUpdate() throws Exception {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(FailBecauseJustUpdate.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseSnapshotMismatch() throws Throwable {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(FailBecauseSnapshotMismatch.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%nUnified diff:%n+[NOT ]test", new Object[0]));
    }

    @Test
    void testFailBecauseInitial() throws Throwable {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(FailBecauseInitial.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been created the first time.%nRun the test again and you should see it succeed.", new Object[0]));
    }

    @Test
    void testMultipleAssertions() throws Exception {
        new MetaTest().expectTestcase(MultipleAssertions.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @Test
    void testSoftAssertions() throws Exception {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(SoftAssertions.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%nUnified diff:%ntest+[2]", new Object[0])).hasSuppressedException((Throwable)new AssertionFailedError(String.format("Stored snapshot doesn't match actual result.%nUnified diff:%ntest+[3]", new Object[0])));
    }

    @EnableSnapshotTests(softAssertions=true)
    static class SoftAssertions {
        SoftAssertions() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"test2").asText().matchesSnapshotText();
            snapshot.assertThat((Object)"test3").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class MultipleAssertions {
        MultipleAssertions() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshot.assertThat((Object)"test2").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class FailBecauseInitial {
        FailBecauseInitial() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshotResult.deleteSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseSnapshotMismatch {
        FailBecauseSnapshotMismatch() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"NOT test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseJustUpdate {
        FailBecauseJustUpdate() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().justUpdateSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests(forceUpdateSnapshots=true)
    static class FailBecauseForceUpdateFromAnnotation {
        FailBecauseForceUpdateFromAnnotation() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }
}

