/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.util;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class InjectedMethodInvocation {
    private final Injector injector;
    private final Object self;
    private final Method method;

    private InjectedMethodInvocation(Injector injector, Object self, Method method) {
        this.injector = injector;
        this.self = self;
        this.method = method;
    }

    public static InjectedMethodInvocation forStatic(Method method, Injector injector) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()));
        Preconditions.checkArgument((injector != null ? 1 : 0) != 0);
        return new InjectedMethodInvocation(injector, null, method);
    }

    public static InjectedMethodInvocation forMethod(Method method, Object self, Injector injector) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"Method must not be null");
        Preconditions.checkArgument((boolean)(self != null ^ Modifier.isStatic(method.getModifiers())), (Object)"Method must either be static or a reference object must be passed");
        Preconditions.checkArgument((injector != null ? 1 : 0) != 0, (Object)"Injector must not be null");
        return new InjectedMethodInvocation(injector, self, method);
    }

    private Object[] getArguments() {
        Object[] result = new Object[this.method.getParameterCount()];
        Errors errors = new Errors((Object)this.method);
        for (int i = 0; i < result.length; ++i) {
            Class<?> type = this.method.getParameterTypes()[i];
            Annotation[] annotations = this.method.getParameterAnnotations()[i];
            Annotation bindingAnnotation = Annotations.findBindingAnnotation((Errors)errors, (Member)this.method, (Annotation[])annotations);
            Key key = bindingAnnotation == null ? Key.get(type) : Key.get(type, (Annotation)bindingAnnotation);
            result[i] = this.injector.getInstance(key);
        }
        errors.throwProvisionExceptionIfErrorsExist();
        return result;
    }

    public Object proceed() throws Throwable {
        boolean accessible = this.method.isAccessible();
        try {
            this.method.setAccessible(true);
            Object object = this.method.invoke(this.self, this.getArguments());
            return object;
        }
        finally {
            this.method.setAccessible(accessible);
        }
    }
}

