/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.trigger;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.annotation.CronType;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.runnables.Reschedulable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class CronTriggerStrategy
implements TriggerStrategy {
    @Inject
    private Injector injector;
    @Inject
    private RunnableBuilder runnableBuilder;
    @Inject
    private ContextFactory contextFactory;

    public Class<CronTrigger> getTriggerType() {
        return CronTrigger.class;
    }

    @Override
    public ScheduledContext schedule(Method method, Object self, ScheduledExecutorService executor, ExceptionHandler handler) {
        CronTrigger trigger = method.getAnnotation(this.getTriggerType());
        Preconditions.checkArgument((trigger != null ? 1 : 0) != 0, (String)"Method '%s' not annotated with @CronTrigger", (Object[])new Object[]{method});
        CronType cronType = trigger.cronType();
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((com.cronutils.model.CronType)cronType.getType());
        CronParser parser = new CronParser(cronDefinition);
        Cron cron = parser.parse(trigger.value());
        ExecutionTime execTime = ExecutionTime.forCron((Cron)cron);
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forMethod(method, self, this.injector);
        ScheduledContext context = this.contextFactory.createContext(method);
        Runnable runnable = this.runnableBuilder.createRunnableStack(invocation, context, handler);
        Reschedulable rescheduleRunnable = this.runnableBuilder.reschedule(context, runnable, executor, execTime);
        rescheduleRunnable.scheduleNextExecution();
        return context;
    }
}

