/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import com.cronutils.model.time.ExecutionTime;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.runnables.LatchLockableRunnable;
import de.skuzzle.inject.async.internal.runnables.Reschedulable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ReScheduleRunnable
implements Reschedulable {
    private final Runnable invocation;
    private final ScheduledExecutorService executor;
    private final ExecutionTime executionTime;
    private final ScheduledContext context;

    private ReScheduleRunnable(ScheduledContext context, Runnable invocation, ScheduledExecutorService executor, ExecutionTime executionTime) {
        this.context = context;
        this.invocation = invocation;
        this.executor = executor;
        this.executionTime = executionTime;
    }

    static Reschedulable of(ScheduledContext context, Runnable invocation, ScheduledExecutorService scheduler, ExecutionTime executionTime) {
        return new ReScheduleRunnable(context, invocation, scheduler, executionTime);
    }

    @Override
    public void run() {
        this.scheduleNextExecution();
        this.invocation.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleNextExecution() {
        ZonedDateTime now = ZonedDateTime.now();
        Duration timeToNext = (Duration)this.executionTime.timeToNextExecution(now).orElseThrow(() -> new IllegalStateException("Could not determine time to next execution"));
        long delay = timeToNext.toMillis();
        LatchLockableRunnable locked = new LatchLockableRunnable(this);
        try {
            ScheduledFuture<?> future = this.executor.schedule(locked, delay, TimeUnit.MILLISECONDS);
            this.context.setFuture(future);
        }
        finally {
            locked.release();
        }
    }
}

