/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;

public class InvocationCallable<T>
implements Callable<T>,
Supplier<T> {
    private final MethodInvocation invocation;

    private InvocationCallable(MethodInvocation invocation) {
        this.invocation = invocation;
    }

    public static InvocationCallable<?> fromInvocation(MethodInvocation invocation) {
        return new InvocationCallable(invocation);
    }

    @Override
    public T call() throws Exception {
        try {
            Object result = this.invocation.proceed();
            if (result instanceof CompletableFuture) {
                return ((CompletableFuture)result).get();
            }
            if (result instanceof Future) {
                return (T)((Future)result).get();
            }
            if (result != null) {
                throw new IllegalStateException("Wrapped invocation is expected to either return null or an instance of (Completable)Future");
            }
            return null;
        }
        catch (Throwable e) {
            Throwables.propagateIfInstanceOf((Throwable)e, Exception.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public T get() {
        try {
            return this.call();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

