/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.context;

import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.ExecutionContext;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.context.ExecutionContextImpl;
import de.skuzzle.inject.async.internal.context.ScheduledContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;

class ScheduledContextImpl
implements ScheduledContext {
    private final Object mutex;
    private final Method method;
    private final Map<String, Object> beanMap;
    private final ThreadLocal<ExecutionContextImpl> execution;
    private volatile int executionCount;
    private volatile Future<?> future;

    public ScheduledContextImpl(Method method) {
        this.method = method;
        this.mutex = new Object();
        this.beanMap = new HashMap<String, Object>();
        this.execution = new ThreadLocal();
    }

    @Override
    public void setFuture(Future<?> future) {
        Preconditions.checkArgument((future != null ? 1 : 0) != 0, (Object)"future must not be null");
        this.future = future;
    }

    private void checkFutureSet() {
        Preconditions.checkState((this.future != null ? 1 : 0) != 0, (Object)"setFuture has not been called. There might be something wrong with the TriggerStrategy implementation.");
    }

    @Override
    public void cancel(boolean mayInterrupt) {
        this.checkFutureSet();
        this.future.cancel(mayInterrupt);
    }

    @Override
    public boolean isCancelled() {
        this.checkFutureSet();
        return this.future.isCancelled();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginNewExecution() {
        ExecutionContextImpl executionContext;
        Object object = this.mutex;
        synchronized (object) {
            executionContext = new ExecutionContextImpl(this.method, this.executionCount++);
        }
        this.execution.set(executionContext);
        ScheduledContextHolder.push(this);
    }

    @Override
    public void finishExecution() {
        ScheduledContextHolder.pop();
        ExecutionContext activeContext = this.execution.get();
        Preconditions.checkState((activeContext != null ? 1 : 0) != 0, (Object)"there is no active ExecutionContext");
        this.execution.set(null);
    }

    @Override
    public int getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public ExecutionContextImpl getExecution() {
        ExecutionContextImpl activeContext = this.execution.get();
        Preconditions.checkState((activeContext != null ? 1 : 0) != 0, (Object)"there is no active ExecutionContext");
        return activeContext;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.beanMap;
    }

    public String toString() {
        return String.format("ScheduledContext[method: %s]", this.method.getName());
    }
}

