/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provider;
import de.skuzzle.inject.async.ExecutionContext;
import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.annotation.ExecutionScope;
import de.skuzzle.inject.async.annotation.ScheduledScope;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.context.ContextFactoryImpl;
import de.skuzzle.inject.async.internal.context.ScheduledContextHolder;
import de.skuzzle.inject.async.util.MapBasedScope;
import de.skuzzle.inject.proxy.ScopedProxyBinder;
import java.util.Map;

public final class ContextModule
extends AbstractModule {
    public ContextModule(GuiceAsync principal) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"instantiating this module is not allowed. Use the class GuiceAsync to enable asynchronous method support.");
    }

    @VisibleForTesting
    ContextModule() {
    }

    protected void configure() {
        this.bind(ContextFactory.class).to(ContextFactoryImpl.class).asEagerSingleton();
        Provider executionMap = () -> ScheduledContextHolder.getContext().getExecution().getProperties();
        this.bindScope(ExecutionScope.class, MapBasedScope.withMapSupplier((Provider<Map<String, Object>>)executionMap));
        Provider scheduledMap = () -> ScheduledContextHolder.getContext().getProperties();
        this.bindScope(ScheduledScope.class, MapBasedScope.withMapSupplier((Provider<Map<String, Object>>)scheduledMap));
        ScopedProxyBinder.using((Binder)this.binder()).bind(ScheduledContext.class).toProvider(ScheduledContextHolder::getContext);
        ScopedProxyBinder.using((Binder)this.binder()).bind(ExecutionContext.class).toProvider(() -> ScheduledContextHolder.getContext().getExecution());
    }
}

