/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.internal.TriggerStrategyRegistry;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpiTriggerStrategyRegistryImpl
implements TriggerStrategyRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SpiTriggerStrategyRegistryImpl.class);
    private final Map<Class<? extends Annotation>, TriggerStrategy> strategies;
    private final Injector injector;

    @Inject
    public SpiTriggerStrategyRegistryImpl(Injector injector) {
        this.injector = injector;
        this.strategies = this.collectTriggerStrategies();
    }

    private Map<Class<? extends Annotation>, TriggerStrategy> collectTriggerStrategies() {
        ServiceLoader<TriggerStrategy> services = ServiceLoader.load(TriggerStrategy.class);
        return SpiTriggerStrategyRegistryImpl.asStream(services).peek(strategy -> LOG.debug("Installing strategy '{}' to handle '{}'", strategy, strategy.getTriggerType())).peek(arg_0 -> ((Injector)this.injector).injectMembers(arg_0)).collect(Collectors.toMap(TriggerStrategy::getTriggerType, Function.identity()));
    }

    private static <T> Stream<T> asStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public TriggerStrategy getStrategyFor(Annotation triggerAnnotation) {
        Preconditions.checkArgument((triggerAnnotation != null ? 1 : 0) != 0);
        Class<? extends Annotation> type = triggerAnnotation.annotationType();
        TriggerStrategy result = this.strategies.get(type);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (String)"There is no TriggerStrategy registered which is able to handle '%s'", (Object[])new Object[]{type.getName()});
        return result;
    }
}

