/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import de.skuzzle.inject.async.SchedulingService;
import de.skuzzle.inject.async.util.MethodVisitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;

class SchedulerTypeListener
implements TypeListener {
    private List<Class<?>> scheduleStatics = Collections.synchronizedList(new ArrayList());
    private volatile boolean injectorReady;
    private final SchedulingService schedulingService;

    SchedulerTypeListener(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    @Inject
    void injectorReady() {
        this.injectorReady = true;
        Consumer<Method> schedule = this.schedulingService::scheduleStaticMethod;
        this.scheduleStatics.forEach(type -> MethodVisitor.forEachStaticMethod(type, schedule));
        this.scheduleStatics.clear();
        this.scheduleStatics = null;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        this.handleStaticScheduling(type.getRawType());
        this.handleMemberScheduling(encounter);
    }

    private void handleStaticScheduling(Class<?> type) {
        if (this.injectorReady) {
            MethodVisitor.forEachStaticMethod(type, this.schedulingService::scheduleStaticMethod);
        } else {
            this.scheduleStatics.add(type);
        }
    }

    private <I> void handleMemberScheduling(TypeEncounter<I> encounter) {
        encounter.register(new InjectionListener<I>(){

            public void afterInjection(I injectee) {
                Consumer<Method> action = method -> SchedulerTypeListener.this.schedulingService.scheduleMemberMethod((Method)method, injectee);
                MethodVisitor.forEachMemberMethod(injectee.getClass(), action);
            }
        });
    }
}

