/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import de.skuzzle.inject.async.GuiceAsyncService;
import de.skuzzle.inject.async.internal.Keys;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuiceAsyncServiceImpl
implements GuiceAsyncService {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceAsyncServiceImpl.class);
    private final Injector injector;

    @Inject
    public GuiceAsyncServiceImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit timeUnit) {
        ScheduledExecutorService scheduler;
        ExecutorService executor = (ExecutorService)this.injector.getInstance(Keys.DEFAULT_EXECUTOR_KEY);
        boolean result = true;
        if (!this.shutdownExecutor(executor, timeout, timeUnit)) {
            LOG.warn("There are still active tasks lingering in default executor after shutdown. Wait time: {} {}", (Object)timeout, (Object)timeUnit);
            result = false;
        }
        if (!this.shutdownExecutor(scheduler = (ScheduledExecutorService)this.injector.getInstance(Keys.DEFAULT_SCHEDULER_KEY), timeout, timeUnit)) {
            LOG.warn("There are still active tasks lingering in default scheduler after shutdown. Wait time: {} {}", (Object)timeout, (Object)timeUnit);
            result = false;
        }
        return result;
    }

    private boolean shutdownExecutor(ExecutorService executor, long timeout, TimeUnit timeUnit) {
        LOG.debug("Shutting down guice-async default executor instance {}", (Object)executor);
        executor.shutdownNow();
        try {
            return executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread currentThread = Thread.currentThread();
            LOG.error("Thread {} interrupted while waiting to shutdown guice-async default executor", (Object)currentThread.getName(), (Object)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

