/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import de.skuzzle.inject.async.internal.Keys;
import de.skuzzle.inject.async.internal.runnables.InvocationCallable;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class AsynchronousMethodInterceptor
implements MethodInterceptor {
    @Inject
    private Injector injector;

    AsynchronousMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        AsynchronousMethodInterceptor.checkReturnType(method.getReturnType());
        Key<? extends ExecutorService> key = Keys.getExecutorKey(method);
        ExecutorService ex = (ExecutorService)this.injector.getInstance(key);
        InvocationCallable<?> callable = InvocationCallable.fromInvocation(invocation);
        if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
            return CompletableFuture.supplyAsync(callable, ex);
        }
        Future<?> future = ex.submit(callable);
        if (AsynchronousMethodInterceptor.isVoid(method.getReturnType())) {
            return null;
        }
        return future;
    }

    private static boolean isVoid(Class<?> type) {
        return type == Void.class || type == Void.TYPE;
    }

    private static void checkReturnType(Class<?> returnType) {
        if (!AsynchronousMethodInterceptor.isVoid(returnType) && !Future.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Methods annotated with @Async must either return void or (Completable)Future");
        }
    }
}

