/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.GuiceAsyncService;
import de.skuzzle.inject.async.SchedulingService;
import de.skuzzle.inject.async.annotation.Async;
import de.skuzzle.inject.async.internal.AsynchronousMethodInterceptor;
import de.skuzzle.inject.async.internal.DefaultBinding;
import de.skuzzle.inject.async.internal.DefaultExceptionHandler;
import de.skuzzle.inject.async.internal.GuiceAsyncServiceImpl;
import de.skuzzle.inject.async.internal.SchedulerTypeListener;
import de.skuzzle.inject.async.internal.SchedulingServiceImpl;
import de.skuzzle.inject.async.internal.SpiTriggerStrategyRegistryImpl;
import de.skuzzle.inject.async.internal.TriggerStrategyRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncModule.class);

    public AsyncModule(GuiceAsync principal) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"instantiating this module is not allowed. Use the class GuiceAsync to enable asynchronous method support.");
    }

    protected void configure() {
        AsynchronousMethodInterceptor asyncInterceptor = new AsynchronousMethodInterceptor();
        this.requestInjection(asyncInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Async.class), new MethodInterceptor[]{asyncInterceptor});
        this.bind(TriggerStrategyRegistry.class).to(SpiTriggerStrategyRegistryImpl.class).in(Singleton.class);
        this.bind(GuiceAsyncService.class).to(GuiceAsyncServiceImpl.class).in(Singleton.class);
        SchedulingServiceImpl schedulingService = new SchedulingServiceImpl((Provider<Injector>)this.getProvider(Injector.class), (Provider<TriggerStrategyRegistry>)this.getProvider(TriggerStrategyRegistry.class));
        SchedulerTypeListener scheduleListener = new SchedulerTypeListener(schedulingService);
        this.bind(SchedulingService.class).toInstance((Object)schedulingService);
        this.requestInjection(scheduleListener);
        this.bindListener(Matchers.any(), scheduleListener);
        LOG.debug("Guice asynchronous method extension has been installed");
    }

    @Provides
    @Singleton
    @DefaultBinding
    ThreadFactory provideThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat("guice-async-%d").build();
    }

    @Provides
    @Singleton
    @DefaultBinding
    ExecutorService provideDefaultExecutor(@DefaultBinding ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }

    @Provides
    @Singleton
    @DefaultBinding
    ScheduledExecutorService provideScheduler(@DefaultBinding ThreadFactory threadFactory) {
        int cores = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(cores, threadFactory);
    }

    @Provides
    @Singleton
    @DefaultBinding
    ExceptionHandler provideDefaultExceptionHandler() {
        return new DefaultExceptionHandler();
    }
}

