/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class MethodVisitor {
    private static final String JACOCO_INIT = "$jacocoInit";

    private MethodVisitor() {
    }

    public static void forEachStaticMethod(Class<?> type, Consumer<Method> action) {
        MethodVisitor.forEachMethod(type, action, MethodVisitor::isStatic);
    }

    public static void forEachMemberMethod(Class<?> type, Consumer<Method> action) {
        MethodVisitor.forEachMethod(type, action, MethodVisitor::notStatic);
    }

    private static void forEachMethod(Class<?> type, Consumer<Method> action, Predicate<Method> filter) {
        if (type == Object.class) {
            return;
        }
        MethodVisitor.forEachMethod(type.getSuperclass(), action, filter);
        Arrays.stream(type.getDeclaredMethods()).filter(filter).forEach(action);
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers()) && !JACOCO_INIT.equals(method.getName());
    }

    private static boolean notStatic(Method method) {
        return !Modifier.isStatic(method.getModifiers());
    }
}

