/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import com.cronutils.model.time.ExecutionTime;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.runnables.ExceptionHandlingRunnable;
import de.skuzzle.inject.async.internal.runnables.InvokeMethodRunnable;
import de.skuzzle.inject.async.internal.runnables.LatchLockableRunnable;
import de.skuzzle.inject.async.internal.runnables.LockableRunnable;
import de.skuzzle.inject.async.internal.runnables.ReScheduleRunnable;
import de.skuzzle.inject.async.internal.runnables.Reschedulable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.internal.runnables.ScopedRunnable;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.util.concurrent.ScheduledExecutorService;

class RunnableBuilderImpl
implements RunnableBuilder {
    RunnableBuilderImpl() {
    }

    @Override
    public Runnable createRunnableStack(InjectedMethodInvocation invocation, ScheduledContext context, ExceptionHandler handler) {
        Runnable invokeRunnable = this.invoke(invocation);
        Runnable errorHandler = this.handleException(invokeRunnable, handler);
        return this.scope(errorHandler, context);
    }

    @Override
    public LockableRunnable createLockedRunnableStack(InjectedMethodInvocation invocation, ScheduledContext context, ExceptionHandler handler) {
        Runnable scoped = this.createRunnableStack(invocation, context, handler);
        return new LatchLockableRunnable(scoped);
    }

    @Override
    public Runnable scope(Runnable unscoped, ScheduledContext context) {
        return ScopedRunnable.of(unscoped, context);
    }

    @Override
    public Runnable invoke(InjectedMethodInvocation invocation) {
        return InvokeMethodRunnable.of(invocation);
    }

    @Override
    public Runnable handleException(Runnable wrapped, ExceptionHandler handler) {
        return new ExceptionHandlingRunnable(wrapped, handler);
    }

    @Override
    public Reschedulable reschedule(ScheduledContext context, Runnable wrapped, ScheduledExecutorService scheduler, ExecutionTime executionTime) {
        return ReScheduleRunnable.of(context, wrapped, scheduler, executionTime);
    }
}

