/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.context;

import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.ScheduledContext;

public final class ScheduledContextHolder {
    private static final ThreadLocal<ScheduledContext> STACK = new ThreadLocal();

    private ScheduledContextHolder() {
    }

    public static boolean isContextActive() {
        return STACK.get() != null;
    }

    public static ScheduledContext getContext() {
        ScheduledContext activeContext = STACK.get();
        Preconditions.checkState((activeContext != null ? 1 : 0) != 0, (Object)"Scope 'ScheduledScope' is currently not active. Either there is no scheduled method being executed on the current thread or the TriggerStrategy that scheduled the method does not support scoped executions");
        return activeContext;
    }

    public static void push(ScheduledContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context may not be null. Use .pop() to disable the currently active context.");
        ScheduledContext activeContext = STACK.get();
        Preconditions.checkState((activeContext == null ? 1 : 0) != 0, (String)"there is currently another ScheduledContext active. There may only be one active context per thread at a time. Currently active context is: '%s'. Tried to set '%s' as active context", (Object[])new Object[]{activeContext, context});
        STACK.set(context);
    }

    public static void pop() {
        Preconditions.checkState((STACK.get() != null ? 1 : 0) != 0, (Object)"there is no active ScheduledContext");
        STACK.set(null);
    }
}

