/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.SchedulingService;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.internal.Annotations;
import de.skuzzle.inject.async.internal.Keys;
import de.skuzzle.inject.async.internal.TriggerStrategyRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulingServiceImpl
implements SchedulingService {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingServiceImpl.class);
    private final Provider<Injector> injector;
    private final Provider<TriggerStrategyRegistry> registry;

    SchedulingServiceImpl(Provider<Injector> injector, Provider<TriggerStrategyRegistry> registry) {
        this.injector = injector;
        this.registry = registry;
    }

    @Override
    public void scheduleMemberMethod(Method method, Object self) {
        this.scheduleMethod(method, self);
    }

    @Override
    public void scheduleStaticMethod(Method method) {
        this.scheduleMethod(method, null);
    }

    private void scheduleMethod(Method method, Object self) {
        if (!method.isAnnotationPresent(Scheduled.class)) {
            return;
        }
        Annotation trigger = Annotations.findTriggerAnnotation(method);
        LOG.trace("Method '{}' is elligible for scheduling. Trigger is: {}", (Object)method, (Object)trigger);
        Key<? extends ScheduledExecutorService> key = Keys.getSchedulerKey(method);
        Key<? extends ExceptionHandler> handlerKey = Keys.getExceptionHandler(method);
        LOG.trace("Scheduler key is: {}, ExceptionHandler key is: {}", key, handlerKey);
        ScheduledExecutorService scheduler = (ScheduledExecutorService)((Injector)this.injector.get()).getInstance(key);
        ExceptionHandler handler = (ExceptionHandler)((Injector)this.injector.get()).getInstance(handlerKey);
        TriggerStrategy strategy = ((TriggerStrategyRegistry)this.registry.get()).getStrategyFor(trigger);
        LOG.trace("Using trigger strategy: {}", (Object)strategy);
        strategy.schedule(method, self, scheduler, handler);
    }
}

