/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Key;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.annotation.Executor;
import de.skuzzle.inject.async.annotation.OnError;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.internal.DefaultBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

final class Keys {
    static final Key<? extends ExecutorService> DEFAULT_EXECUTOR_KEY = Key.get(ExecutorService.class, DefaultBinding.class);
    static final Key<? extends ScheduledExecutorService> DEFAULT_SCHEDULER_KEY = Key.get(ScheduledExecutorService.class, DefaultBinding.class);
    private static final Key<? extends ExceptionHandler> DEFAULT_EXCEPTION_HANDLER_KEY = Key.get(ExceptionHandler.class, DefaultBinding.class);

    private Keys() {
    }

    public static Key<? extends ExceptionHandler> getExceptionHandler(Method method) {
        OnError onError = method.getAnnotation(OnError.class);
        if (onError != null) {
            return Key.get(onError.value());
        }
        return DEFAULT_EXCEPTION_HANDLER_KEY;
    }

    public static Key<? extends ExecutorService> getExecutorKey(Method method) {
        Class<ExecutorService> type;
        boolean executorSpecified = false;
        if (method.isAnnotationPresent(Executor.class)) {
            type = method.getAnnotation(Executor.class).value();
            executorSpecified = true;
        } else {
            type = ExecutorService.class;
        }
        return Keys.createKey(type, method, DEFAULT_EXECUTOR_KEY, executorSpecified);
    }

    public static Key<? extends ScheduledExecutorService> getSchedulerKey(Method method) {
        Class<ScheduledExecutorService> type;
        boolean executorSpecified = false;
        if (method.isAnnotationPresent(Scheduler.class)) {
            type = method.getAnnotation(Scheduler.class).value();
            executorSpecified = true;
        } else {
            type = ScheduledExecutorService.class;
        }
        return Keys.createKey(type, method, DEFAULT_SCHEDULER_KEY, executorSpecified);
    }

    private static Key<?> createKey(Class<?> type, Method method, Key<?> defaultKey, boolean typeGiven) {
        Errors errors = new Errors((Object)method);
        Annotation bindingAnnotation = Annotations.findBindingAnnotation((Errors)errors, (Member)method, (Annotation[])method.getAnnotations());
        errors.throwConfigurationExceptionIfErrorsExist();
        Key key = bindingAnnotation == null && typeGiven ? Key.get(type) : (bindingAnnotation == null ? defaultKey : Key.get(type, (Annotation)bindingAnnotation));
        return key;
    }
}

