/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.context.ScheduledContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    DefaultExceptionHandler() {
    }

    @Override
    public void onException(Exception exception) {
        if (ScheduledContextHolder.isContextActive()) {
            ScheduledContext ctx = ScheduledContextHolder.getContext();
            LOG.error("Unexpected error while executing a scheduled method. Context: {}", (Object)ctx, (Object)exception);
        } else {
            LOG.error("Unexpected error occurred while executing scheduled method. Note: there is no ScheduledContext information available. Either the TriggerStrategy in place does not support scoped executions or it may be buggy.", (Throwable)exception);
        }
    }
}

