/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import de.skuzzle.inject.async.annotation.Trigger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

final class Annotations {
    private Annotations() {
    }

    static Annotation findTriggerAnnotation(Method method) {
        Annotation result = null;
        for (Annotation annotation : method.getAnnotations()) {
            if (!Annotations.isTriggerAnnotation(annotation)) continue;
            if (result == null) {
                result = annotation;
                continue;
            }
            throw new IllegalStateException(String.format("Multiple @Trigger annotations found on '%s': %s, %s", method, result, annotation));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("No @Trigger annotation found on '%s'", method));
        }
        return result;
    }

    private static boolean isTriggerAnnotation(Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        return type.isAnnotationPresent(Trigger.class);
    }
}

