/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import de.skuzzle.inject.async.internal.AsyncModule;
import de.skuzzle.inject.async.internal.context.ContextModule;
import de.skuzzle.inject.async.internal.runnables.RunnablesModule;

public final class GuiceAsync {
    private GuiceAsync() {
    }

    public static void enableFor(Binder binder) {
        Preconditions.checkArgument((binder != null ? 1 : 0) != 0, (Object)"binder must not be null");
        binder.install(GuiceAsync.createModule());
    }

    public static Module createModule() {
        GuiceAsync principal = new GuiceAsync();
        return new GuiceAsyncModule(principal);
    }

    private static final class GuiceAsyncModule
    extends AbstractModule {
        private final GuiceAsync principal;

        public GuiceAsyncModule(GuiceAsync principal) {
            this.principal = principal;
        }

        protected void configure() {
            this.install((Module)new AsyncModule(this.principal));
            this.install((Module)new ContextModule(this.principal));
            this.install((Module)new RunnablesModule(this.principal));
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            return obj instanceof GuiceAsyncModule;
        }
    }
}

