/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.util;

import de.skuzzle.inject.async.util.MethodVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MethodVisitorTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testVisitAll() throws Exception {
        HashSet visited = new HashSet();
        MethodVisitor.forEachMemberMethod(SubClass.class, visited::add);
        Assert.assertEquals((long)4L, (long)visited.size());
    }

    @Test
    public void testVisitAllObject() throws Exception {
        HashSet visited = new HashSet();
        MethodVisitor.forEachMemberMethod(Object.class, visited::add);
        Assert.assertEquals((long)0L, (long)visited.size());
    }

    @Test
    public void testPrivateCtor() throws Exception {
        Constructor ctor = MethodVisitor.class.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        ctor.newInstance(new Object[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(ctor.getModifiers()));
    }

    @Test
    public void testVisitStatic() throws Exception {
        HashSet visited = new HashSet();
        MethodVisitor.forEachStaticMethod(SuperClass.class, visited::add);
        Assert.assertEquals((long)1L, (long)visited.size());
    }

    @Test
    public void testVisitStaticAll() throws Exception {
        HashSet visited = new HashSet();
        MethodVisitor.forEachStaticMethod(SubClass.class, visited::add);
        Assert.assertEquals((long)2L, (long)visited.size());
    }

    public static class SubClass
    extends SuperClass {
        private static void staticPrivateMethod() {
        }

        public void pulicMethod() {
        }

        private void privateMethod() {
        }
    }

    public static class SuperClass {
        public static void staticSuperMethod() {
        }

        public void publicSuperMethod() {
        }

        private void privateSuperMethod() {
        }
    }
}

