/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.util;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.internal.CircularDependencyProxy;
import de.skuzzle.inject.async.util.MapBasedScope;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MapBasedScopeTest {
    private Map<String, Object> scopeMap;
    private Scope subject;

    @Before
    public void setup() {
        this.scopeMap = new HashMap<String, Object>();
        Provider provider = () -> this.scopeMap;
        this.subject = MapBasedScope.withMapSupplier((Provider)provider);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithNull() throws Exception {
        MapBasedScope.withMapSupplier(null);
    }

    @Test
    public void testScopeNull() throws Exception {
        Provider unscoped = () -> null;
        Provider scoped = this.subject.scope(Key.get(String.class), unscoped);
        Assert.assertNull((Object)scoped.get());
        Assert.assertNull((Object)scoped.get());
    }

    @Test
    public void testScopeNonNull() throws Exception {
        Provider unscoped = () -> new String("foo");
        Provider scoped = this.subject.scope(Key.get(String.class), unscoped);
        String first = (String)scoped.get();
        String second = (String)scoped.get();
        Assert.assertSame((Object)first, (Object)second);
    }

    @Test
    public void testDontScopeProxies() throws Exception {
        Provider unscoped = () -> (CircularDependencyProxy)Mockito.mock(CircularDependencyProxy.class);
        Provider scoped = this.subject.scope(Key.get(CircularDependencyProxy.class), unscoped);
        CircularDependencyProxy first = (CircularDependencyProxy)scoped.get();
        CircularDependencyProxy second = (CircularDependencyProxy)scoped.get();
        Assert.assertNotSame((Object)first, (Object)second);
    }
}

