/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.util;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InjectedMethodInvocationTest {
    private Injector injector;
    private boolean invoked;
    private static boolean invokedStatic;

    @Before
    public void setUp() throws Exception {
        invokedStatic = false;
        this.invoked = false;
        this.injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)5);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"foo")).toInstance((Object)"foobar");
            }
        }});
    }

    public void nonStaticMethod(Integer i, @Named(value="foo") String s) {
        Assert.assertEquals((long)5L, (long)i.intValue());
        Assert.assertEquals((Object)"foobar", (Object)s);
        this.invoked = true;
    }

    public static void staticMethod(Integer i, @Named(value="foo") String s) {
        Assert.assertEquals((long)5L, (long)i.intValue());
        Assert.assertEquals((Object)"foobar", (Object)s);
        invokedStatic = true;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForStaticMethodWithSelf() throws Exception {
        Method method = this.getClass().getMethod("staticMethod", Integer.class, String.class);
        InjectedMethodInvocation.forMethod((Method)method, (Object)this, (Injector)this.injector);
    }

    @Test
    public void testCallNonStaticMethod() throws Throwable {
        Method method = this.getClass().getMethod("nonStaticMethod", Integer.class, String.class);
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forMethod((Method)method, (Object)this, (Injector)this.injector);
        invocation.proceed();
        Assert.assertTrue((boolean)this.invoked);
    }

    @Test
    public void testCallStaticMethod() throws Throwable {
        Method method = this.getClass().getMethod("staticMethod", Integer.class, String.class);
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forStatic((Method)method, (Injector)this.injector);
        invocation.proceed();
        Assert.assertTrue((boolean)invokedStatic);
    }

    @Test
    public void testCallStaticMethod2() throws Throwable {
        Method method = this.getClass().getMethod("staticMethod", Integer.class, String.class);
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forMethod((Method)method, null, (Injector)this.injector);
        invocation.proceed();
        Assert.assertTrue((boolean)invokedStatic);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForMethodIllegalModifier() throws Exception {
        Method method = this.getClass().getMethod("nonStaticMethod", Integer.class, String.class);
        InjectedMethodInvocation.forStatic((Method)method, (Injector)this.injector);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForStaticNullInjector() throws Exception {
        Method method = this.getClass().getMethod("staticMethod", Integer.class, String.class);
        InjectedMethodInvocation.forStatic((Method)method, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForStaticNullMethod() throws Exception {
        InjectedMethodInvocation.forStatic(null, (Injector)this.injector);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForMethodNullMethod() throws Exception {
        InjectedMethodInvocation.forMethod(null, (Object)this, (Injector)this.injector);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForMethodNullInjector() throws Exception {
        Method method = this.getClass().getMethod("nonStaticMethod", Integer.class, String.class);
        InjectedMethodInvocation.forMethod((Method)method, (Object)this, null);
    }
}

