/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.trigger;

import com.google.inject.Injector;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.annotation.SimpleScheduleType;
import de.skuzzle.inject.async.annotation.SimpleTrigger;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.runnables.LockableRunnable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.internal.trigger.SimpleTriggerStrategy;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleTriggerStrategyTest {
    @Mock
    private Injector injector;
    @Mock
    private RunnableBuilder runnableBuilder;
    @Mock
    private ContextFactory contextFactory;
    @InjectMocks
    private SimpleTriggerStrategy subject;
    @Mock
    private ScheduledExecutorService executorService;
    @Mock
    private ScheduledContext context;
    @Mock
    private ExceptionHandler exceptionHandler;

    @Before
    public void setup() {
        Mockito.when((Object)this.contextFactory.createContext((Method)Matchers.any())).thenReturn((Object)this.context);
    }

    @Scheduled
    @Scheduler(value=ScheduledExecutorService.class)
    @SimpleTrigger(value=5000L, initialDelay=12L, scheduleType=SimpleScheduleType.WITH_FIXED_DELAY, timeUnit=TimeUnit.HOURS)
    public void methodWithSimpleTrigger() {
    }

    @Scheduled
    @Scheduler(value=ScheduledExecutorService.class)
    public void methodWithoutTrigger() {
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoTrigger() throws Exception {
        Method method = this.getClass().getMethod("methodWithoutTrigger", new Class[0]);
        this.subject.schedule(method, (Object)this, this.executorService, this.exceptionHandler);
    }

    @Test
    public void testSchedule() throws Exception {
        Method method = this.getClass().getMethod("methodWithSimpleTrigger", new Class[0]);
        LockableRunnable runnable = (LockableRunnable)Mockito.mock(LockableRunnable.class);
        ScheduledFuture future = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(this.executorService.scheduleWithFixedDelay((Runnable)runnable, 12L, 5000L, TimeUnit.HOURS)).thenReturn((Object)future);
        Mockito.when((Object)this.runnableBuilder.createLockedRunnableStack((InjectedMethodInvocation)Matchers.any(), (ScheduledContext)Matchers.eq((Object)this.context), (ExceptionHandler)Matchers.eq((Object)this.exceptionHandler))).thenReturn((Object)runnable);
        this.subject.schedule(method, (Object)this, this.executorService, this.exceptionHandler);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.executorService, this.context, runnable});
        ((ScheduledExecutorService)order.verify((Object)this.executorService)).scheduleWithFixedDelay((Runnable)runnable, 12L, 5000L, TimeUnit.HOURS);
        ((ScheduledContext)order.verify((Object)this.context)).setFuture((Future)future);
        ((LockableRunnable)order.verify((Object)runnable)).release();
    }
}

