/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.trigger;

import com.google.inject.Injector;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.annotation.DelayedTrigger;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.runnables.LockableRunnable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.internal.trigger.DelayedTriggerStrategy;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DelayedTriggerStrategyTest {
    @Mock
    private Injector injector;
    @Mock
    private RunnableBuilder runnableBuilder;
    @Mock
    private ScheduledExecutorService scheduler;
    @Mock
    private ContextFactory contextFactory;
    @InjectMocks
    private DelayedTriggerStrategy subject;
    @Mock
    private ScheduledContext scheduledContext;
    @Mock
    private ExceptionHandler exceptionHandler;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.contextFactory.createContext((Method)Matchers.any())).thenReturn((Object)this.scheduledContext);
    }

    @Scheduled
    @DelayedTrigger(value=5000L, timeUnit=TimeUnit.DAYS)
    public void methodWithTrigger() {
    }

    public void methodWithoutTrigger() {
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingTrigger() throws Exception {
        Method method = this.getClass().getMethod("methodWithoutTrigger", new Class[0]);
        this.subject.schedule(method, (Object)this, this.scheduler, this.exceptionHandler);
    }

    @Test
    public void testSchedule() throws Exception {
        Method method = this.getClass().getMethod("methodWithTrigger", new Class[0]);
        LockableRunnable runnable = (LockableRunnable)Mockito.mock(LockableRunnable.class);
        ScheduledFuture future = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(this.scheduler.schedule((Runnable)runnable, 5000L, TimeUnit.DAYS)).thenReturn((Object)future);
        Mockito.when((Object)this.runnableBuilder.createLockedRunnableStack((InjectedMethodInvocation)Matchers.any(), (ScheduledContext)Matchers.eq((Object)this.scheduledContext), (ExceptionHandler)Matchers.eq((Object)this.exceptionHandler))).thenReturn((Object)runnable);
        this.subject.schedule(method, (Object)this, this.scheduler, this.exceptionHandler);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.scheduler, this.scheduledContext, runnable});
        ((ScheduledExecutorService)order.verify((Object)this.scheduler)).schedule((Runnable)runnable, 5000L, TimeUnit.DAYS);
        ((ScheduledContext)order.verify((Object)this.scheduledContext)).setFuture((Future)future);
        ((LockableRunnable)order.verify((Object)runnable)).release();
    }
}

