/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.trigger;

import com.cronutils.model.time.ExecutionTime;
import com.google.inject.Injector;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.runnables.Reschedulable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.internal.trigger.CronTriggerStrategy;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CronTriggerStrategyTest {
    @Mock
    private Injector injector;
    @Mock
    private RunnableBuilder runnableBuilder;
    @Mock
    private ContextFactory contextFactory;
    @InjectMocks
    private CronTriggerStrategy subject;
    @Mock
    private ScheduledExecutorService executor;
    @Mock
    private ExceptionHandler exceptionHandler;
    @Mock
    private ScheduledContext scheduledContext;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.contextFactory.createContext((Method)Matchers.any())).thenReturn((Object)this.scheduledContext);
    }

    @CronTrigger(value="0/5 * * * * ?")
    public void scheduledMethod() {
    }

    public void missingTrigger() {
    }

    @Test
    public void testGetTriggerType() throws Exception {
        Assert.assertEquals(CronTrigger.class, (Object)this.subject.getTriggerType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleMissingTrigger() throws Exception {
        Method method = this.getClass().getMethod("missingTrigger", new Class[0]);
        this.subject.schedule(method, (Object)this, this.executor, this.exceptionHandler);
    }

    @Test
    public void testSchedule() throws Exception {
        Method method = this.getClass().getMethod("scheduledMethod", new Class[0]);
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Reschedulable reschedule = (Reschedulable)Mockito.mock(Reschedulable.class);
        Mockito.when((Object)this.runnableBuilder.createRunnableStack((InjectedMethodInvocation)Matchers.any(), (ScheduledContext)Matchers.eq((Object)this.scheduledContext), (ExceptionHandler)Matchers.eq((Object)this.exceptionHandler))).thenReturn((Object)runnable);
        Mockito.when((Object)this.runnableBuilder.reschedule((ScheduledContext)Matchers.eq((Object)this.scheduledContext), (Runnable)Matchers.eq((Object)runnable), (ScheduledExecutorService)Matchers.eq((Object)this.executor), (ExecutionTime)Matchers.any())).thenReturn((Object)reschedule);
        this.subject.schedule(method, (Object)this, this.executor, this.exceptionHandler);
        ((Reschedulable)Mockito.verify((Object)reschedule)).scheduleNextExecution();
    }
}

