/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.runnables.ScopedRunnable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ScopedRunnableTest {
    @Mock
    private Runnable wrapped;
    @Mock
    ScheduledContext context;
    private Runnable subject;

    @Before
    public void setup() {
        this.subject = ScopedRunnable.of((Runnable)this.wrapped, (ScheduledContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrappedNull() throws Exception {
        ScopedRunnable.of(null, (ScheduledContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextNull() throws Exception {
        ScopedRunnable.of((Runnable)this.wrapped, null);
    }

    @Test
    public void testRunScoped() throws Exception {
        this.subject.run();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.wrapped});
        ((ScheduledContext)order.verify((Object)this.context)).beginNewExecution();
        ((Runnable)order.verify((Object)this.wrapped)).run();
        ((ScheduledContext)order.verify((Object)this.context)).finishExecution();
    }

    @Test(expected=RuntimeException.class)
    public void testRunScopedWithException() throws Exception {
        ((Runnable)Mockito.doThrow(RuntimeException.class).when((Object)this.wrapped)).run();
        this.subject.run();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.wrapped});
        ((ScheduledContext)order.verify((Object)this.context)).beginNewExecution();
        ((Runnable)order.verify((Object)this.wrapped)).run();
        ((ScheduledContext)order.verify((Object)this.context)).finishExecution();
    }
}

