/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.runnables.LockableRunnable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilderImpl;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RunnableBuilderImplTest {
    @Mock
    private InjectedMethodInvocation invocation;
    @Mock
    private ScheduledContext context;
    @Mock
    private ExceptionHandler handler;
    private final RunnableBuilderImpl subject = new RunnableBuilderImpl();

    @Test
    public void testCreateRunnableStack() throws Throwable {
        Runnable runnable = this.subject.createRunnableStack(this.invocation, this.context, this.handler);
        runnable.run();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.invocation, this.context, this.handler});
        ((ScheduledContext)order.verify((Object)this.context)).beginNewExecution();
        ((InjectedMethodInvocation)order.verify((Object)this.invocation)).proceed();
        ((ScheduledContext)order.verify((Object)this.context)).finishExecution();
    }

    @Test
    public void testCreateLockedRunnable() throws Throwable {
        LockableRunnable runnable = this.subject.createLockedRunnableStack(this.invocation, this.context, this.handler);
        runnable.release();
        runnable.run();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.invocation, this.context, this.handler});
        ((ScheduledContext)order.verify((Object)this.context)).beginNewExecution();
        ((InjectedMethodInvocation)order.verify((Object)this.invocation)).proceed();
        ((ScheduledContext)order.verify((Object)this.context)).finishExecution();
    }

    @Test
    public void testCreateRunnableStackException() throws Throwable {
        RuntimeException ex = new RuntimeException();
        Mockito.when((Object)this.invocation.proceed()).thenThrow(new Throwable[]{ex});
        Runnable runnable = this.subject.createRunnableStack(this.invocation, this.context, this.handler);
        runnable.run();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.invocation, this.context, this.handler});
        ((ScheduledContext)order.verify((Object)this.context)).beginNewExecution();
        ((InjectedMethodInvocation)order.verify((Object)this.invocation)).proceed();
        ((ExceptionHandler)order.verify((Object)this.handler)).onException((Exception)ex);
        ((ScheduledContext)order.verify((Object)this.context)).finishExecution();
    }
}

