/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import de.skuzzle.inject.async.internal.runnables.LatchLockableRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LatchLockableRunnableTest {
    @Mock
    private Runnable runnable;
    @InjectMocks
    private LatchLockableRunnable subject;

    @Test(timeout=5000L)
    public void testRunAfterRelease() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute((Runnable)this.subject);
        Thread.sleep(250L);
        ((Runnable)Mockito.verify((Object)this.runnable, (VerificationMode)Mockito.never())).run();
        this.subject.release();
        Thread.sleep(250L);
        ((Runnable)Mockito.verify((Object)this.runnable)).run();
    }

    @Test(timeout=5000L)
    public void testRunInterrupt() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute((Runnable)this.subject);
        Thread.sleep(250L);
        executor.shutdownNow();
        ((Runnable)Mockito.verify((Object)this.runnable, (VerificationMode)Mockito.never())).run();
    }
}

