/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import de.skuzzle.inject.async.internal.runnables.InvokeMethodRunnable;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InvokeMethodRunnableTest {
    @Mock
    private InjectedMethodInvocation invocation;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testRun() throws Throwable {
        Runnable r = InvokeMethodRunnable.of((InjectedMethodInvocation)this.invocation);
        r.run();
        ((InjectedMethodInvocation)Mockito.verify((Object)this.invocation)).proceed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOfNull() throws Exception {
        InvokeMethodRunnable.of(null);
    }

    @Test(expected=RuntimeException.class)
    public void testRunThrowsRuntimeException() throws Throwable {
        ((InjectedMethodInvocation)Mockito.doThrow(RuntimeException.class).when((Object)this.invocation)).proceed();
        Runnable r = InvokeMethodRunnable.of((InjectedMethodInvocation)this.invocation);
        r.run();
    }

    @Test(expected=Error.class)
    public void testRunThrowError() throws Throwable {
        ((InjectedMethodInvocation)Mockito.doThrow(Error.class).when((Object)this.invocation)).proceed();
        Runnable r = InvokeMethodRunnable.of((InjectedMethodInvocation)this.invocation);
        r.run();
    }
}

