/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.context;

import de.skuzzle.inject.async.internal.context.ExecutionContextImpl;
import de.skuzzle.inject.async.internal.context.ScheduledContextHolder;
import de.skuzzle.inject.async.internal.context.ScheduledContextImpl;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ScheduledContextImplTest {
    private ScheduledContextImpl subject;

    public void justAMethod() {
    }

    @Before
    public void setup() throws NoSuchMethodException, SecurityException {
        if (ScheduledContextHolder.isContextActive()) {
            ScheduledContextHolder.pop();
        }
        Method method = this.getClass().getMethod("justAMethod", new Class[0]);
        this.subject = new ScheduledContextImpl(method);
    }

    @After
    public void cleanup() {
        if (ScheduledContextHolder.isContextActive()) {
            ScheduledContextHolder.pop();
        }
    }

    @Test
    public void testInitial() throws Exception {
        Assert.assertEquals((long)0L, (long)this.subject.getExecutionCount());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetExecutionNotActive() throws Exception {
        this.subject.getExecution();
    }

    @Test
    public void testBeginFinish() throws Exception {
        this.subject.beginNewExecution();
        ExecutionContextImpl ctx = this.subject.getExecution();
        Assert.assertEquals((long)0L, (long)ctx.getExecutionNr());
        Assert.assertEquals((long)1L, (long)this.subject.getExecutionCount());
        Assert.assertEquals((Object)ctx.getMethod(), (Object)this.subject.getMethod());
        Assert.assertTrue((boolean)ScheduledContextHolder.isContextActive());
        Assert.assertEquals((Object)this.subject, (Object)ScheduledContextHolder.getContext());
        this.subject.finishExecution();
        Assert.assertFalse((boolean)ScheduledContextHolder.isContextActive());
        Assert.assertEquals((long)1L, (long)this.subject.getExecutionCount());
    }

    @Test(expected=IllegalStateException.class)
    public void testCancelNoFuture() throws Exception {
        this.subject.cancel(false);
    }

    @Test(expected=IllegalStateException.class)
    public void testIsCancelledNoFuture() throws Exception {
        this.subject.isCancelled();
    }

    @Test
    public void testCancel() throws Exception {
        Future future = (Future)Mockito.mock(Future.class);
        this.subject.setFuture(future);
        this.subject.cancel(true);
        ((Future)Mockito.verify((Object)future)).cancel(true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFutureNull() throws Exception {
        this.subject.setFuture(null);
    }

    @Test
    public void testIsCancelled() throws Exception {
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)future.isCancelled()).thenReturn((Object)true);
        this.subject.setFuture(future);
        Assert.assertTrue((boolean)this.subject.isCancelled());
    }
}

