/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.context;

import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.internal.context.ScheduledContextHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ScheduledContextHolderTest {
    @Before
    public void setup() {
        if (ScheduledContextHolder.isContextActive()) {
            ScheduledContextHolder.pop();
        }
    }

    @After
    public void after() {
        if (ScheduledContextHolder.isContextActive()) {
            ScheduledContextHolder.pop();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testPopNotPresent() throws Exception {
        ScheduledContextHolder.pop();
    }

    @Test
    public void testPushPop() throws Exception {
        ScheduledContext ctx = (ScheduledContext)Mockito.mock(ScheduledContext.class);
        ScheduledContextHolder.push((ScheduledContext)ctx);
        Assert.assertTrue((boolean)ScheduledContextHolder.isContextActive());
        Assert.assertEquals((Object)ctx, (Object)ScheduledContextHolder.getContext());
        ScheduledContextHolder.pop();
        Assert.assertFalse((boolean)ScheduledContextHolder.isContextActive());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetContextNotActive() throws Exception {
        ScheduledContextHolder.getContext();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPushNull() throws Exception {
        ScheduledContextHolder.push(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testPushWhileActive() throws Exception {
        ScheduledContext ctx = (ScheduledContext)Mockito.mock(ScheduledContext.class);
        ScheduledContextHolder.push((ScheduledContext)ctx);
        ScheduledContextHolder.push((ScheduledContext)ctx);
    }
}

