/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.internal.SpiTriggerStrategyRegistryImpl;
import de.skuzzle.inject.async.internal.trigger.CronTriggerStrategy;
import java.lang.annotation.Annotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpiTriggerStrategyRegistryImplTest {
    @Mock
    private Injector injector;
    @Mock
    private Annotation triggerAnnotation;
    @InjectMocks
    private SpiTriggerStrategyRegistryImpl subject;

    @Before
    public void setup() {
        Mockito.when(this.triggerAnnotation.annotationType()).thenReturn(CronTrigger.class);
    }

    @Test
    public void testGetStrategyFor() throws Exception {
        TriggerStrategy strategy = this.subject.getStrategyFor(this.triggerAnnotation);
        ((Injector)Mockito.verify((Object)this.injector)).injectMembers(Mockito.isA(CronTriggerStrategy.class));
        Assert.assertTrue((boolean)(strategy instanceof CronTriggerStrategy));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetStrategyForUnknown() throws Exception {
        Mockito.when(this.triggerAnnotation.annotationType()).thenReturn(Scheduled.class);
        this.subject.getStrategyFor(this.triggerAnnotation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStrategyforNull() throws Exception {
        this.subject.getStrategyFor(null);
    }
}

