/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.spi.InjectionListener;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.annotation.OnError;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.internal.SchedulerTypeListenerTest;
import de.skuzzle.inject.async.internal.SchedulingServiceImpl;
import de.skuzzle.inject.async.internal.TriggerStrategyRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SchedulingServiceImplTest {
    @Mock
    private Injector injector;
    @Mock
    private TriggerStrategyRegistry registry;
    @Captor
    private ArgumentCaptor<InjectionListener<SchedulerTypeListenerTest>> captor;
    @Mock
    private ScheduledExecutorService scheduler;
    @Mock
    private TriggerStrategy triggerStrategy;
    @Mock
    private ExceptionHandler exceptionHandler;
    private SchedulingServiceImpl subject;

    @Before
    public void setUp() throws Exception {
        this.subject = new SchedulingServiceImpl(SchedulingServiceImplTest.provider(this.injector), SchedulingServiceImplTest.provider(this.registry));
        Mockito.when((Object)this.injector.getInstance(Key.get(ExceptionHandler.class))).thenReturn((Object)this.exceptionHandler);
        Mockito.when((Object)this.injector.getInstance(Key.get(ScheduledExecutorService.class))).thenReturn((Object)this.scheduler);
        Mockito.when((Object)this.registry.getStrategyFor((Annotation)Mockito.any())).thenReturn((Object)this.triggerStrategy);
    }

    private static <T> Provider<T> provider(T t) {
        return () -> t;
    }

    @Scheduled
    @CronTrigger(value="* * * * * *")
    @Scheduler(value=ScheduledExecutorService.class)
    @OnError(value=ExceptionHandler.class)
    public void methodWithTrigger() {
    }

    @Scheduled
    @CronTrigger(value="* * * * * *")
    @Scheduler(value=ScheduledExecutorService.class)
    @OnError(value=ExceptionHandler.class)
    public static void staticMethodWithTrigger() {
    }

    public void methodWithouTrigger() {
    }

    @Test
    public void testNoTrigger() throws Exception {
        Method expectedMethod = this.getClass().getMethod("methodWithouTrigger", new Class[0]);
        this.subject.scheduleMemberMethod(expectedMethod, (Object)this);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.triggerStrategy});
    }

    @Test
    public void testScheduleMemberMethod() throws Exception {
        Method expectedMethod = this.getClass().getMethod("methodWithTrigger", new Class[0]);
        this.subject.scheduleMemberMethod(expectedMethod, (Object)this);
        ((TriggerStrategy)Mockito.verify((Object)this.triggerStrategy)).schedule(expectedMethod, (Object)this, this.scheduler, this.exceptionHandler);
    }

    @Test
    public void testScheduleStaticMethod() throws Exception {
        Method expectedMethod = this.getClass().getMethod("staticMethodWithTrigger", new Class[0]);
        this.subject.scheduleStaticMethod(expectedMethod);
        ((TriggerStrategy)Mockito.verify((Object)this.triggerStrategy)).schedule(expectedMethod, null, this.scheduler, this.exceptionHandler);
    }
}

