/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.SchedulingService;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.annotation.OnError;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.internal.SchedulerTypeListener;
import de.skuzzle.inject.async.internal.TriggerStrategyRegistry;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SchedulerTypeListenerTest {
    @Mock
    private TypeEncounter<SchedulerTypeListenerTest> encounter;
    @Mock
    private Injector injector;
    @Mock
    private TriggerStrategyRegistry registry;
    @Captor
    private ArgumentCaptor<InjectionListener<SchedulerTypeListenerTest>> captor;
    @Mock
    private ScheduledExecutorService scheduler;
    @Mock
    private ExceptionHandler exceptionHandler;
    @Mock
    private SchedulingService schedulingService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.encounter.getProvider(Injector.class)).thenReturn(SchedulerTypeListenerTest.provider(this.injector));
        Mockito.when((Object)this.encounter.getProvider(TriggerStrategyRegistry.class)).thenReturn(SchedulerTypeListenerTest.provider(this.registry));
        Mockito.when((Object)this.injector.getInstance(Key.get(ExceptionHandler.class))).thenReturn((Object)this.exceptionHandler);
        Mockito.when((Object)this.injector.getInstance(Key.get(ScheduledExecutorService.class))).thenReturn((Object)this.scheduler);
    }

    private static <T> Provider<T> provider(T t) {
        return () -> t;
    }

    @Scheduled
    @CronTrigger(value="* * * * * *")
    @Scheduler(value=ScheduledExecutorService.class)
    @OnError(value=ExceptionHandler.class)
    public void methodWithTrigger() {
    }

    @Scheduled
    @CronTrigger(value="* * * * * *")
    @Scheduler(value=ScheduledExecutorService.class)
    @OnError(value=ExceptionHandler.class)
    public static void staticMethodWithTrigger() {
    }

    @Test
    public void testHear() throws Exception {
        Method expectedMethod = this.getClass().getMethod("methodWithTrigger", new Class[0]);
        Method expectedStaticMethod = this.getClass().getMethod("staticMethodWithTrigger", new Class[0]);
        TypeLiteral<SchedulerTypeListenerTest> type = new TypeLiteral<SchedulerTypeListenerTest>(){};
        SchedulerTypeListener subject = new SchedulerTypeListener(this.schedulingService);
        subject.hear((TypeLiteral)type, this.encounter);
        ((TypeEncounter)Mockito.verify(this.encounter)).register((InjectionListener)this.captor.capture());
        InjectionListener listener = (InjectionListener)this.captor.getValue();
        listener.afterInjection((Object)this);
        ((SchedulingService)Mockito.verify((Object)this.schedulingService)).scheduleMemberMethod(expectedMethod, (Object)this);
        subject.injectorReady();
        ((SchedulingService)Mockito.verify((Object)this.schedulingService)).scheduleStaticMethod(expectedStaticMethod);
    }
}

