/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Key;
import com.google.inject.name.Named;
import de.skuzzle.inject.async.annotation.Executor;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.internal.DefaultBinding;
import de.skuzzle.inject.async.internal.Keys;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Assert;
import org.junit.Test;

public class KeysTest {
    public void methodWithNoAnnotations() {
    }

    @javax.inject.Named(value="foo")
    public void methodWithBindingAnnoation() {
    }

    @Executor(value=ScheduledExecutorService.class)
    @Scheduler(value=ScheduledExecutorService.class)
    public void methodWithExecutorOnly() {
    }

    @Named(value="xyz")
    @Executor(value=ScheduledExecutorService.class)
    public void methodWithBindingAndType() {
    }

    private void assertType(Class<?> type, Key<?> key) {
        Assert.assertEquals(type, (Object)key.getTypeLiteral().getRawType());
    }

    private void assertBindingAnnotation(Class<? extends Annotation> bindingAnnotationType, Key<?> key) {
        Assert.assertEquals(bindingAnnotationType, (Object)key.getAnnotationType());
    }

    private Method getMethod(String name) throws NoSuchMethodException, SecurityException {
        return this.getClass().getMethod(name, new Class[0]);
    }

    @Test
    public void testFallBackDefault() throws Exception {
        Method method = this.getMethod("methodWithNoAnnotations");
        Key key = Keys.getExecutorKey((Method)method);
        this.assertType(ExecutorService.class, key);
        this.assertBindingAnnotation(DefaultBinding.class, key);
    }

    @Test
    public void testBindingAnnotationOnlyExecutor() throws Exception {
        Method method = this.getMethod("methodWithBindingAnnoation");
        Key key = Keys.getExecutorKey((Method)method);
        this.assertType(ExecutorService.class, key);
        this.assertBindingAnnotation(Named.class, key);
    }

    @Test
    public void testBindingAnnotationOnlyScheduler() throws Exception {
        Method method = this.getMethod("methodWithBindingAnnoation");
        Key key = Keys.getSchedulerKey((Method)method);
        this.assertType(ScheduledExecutorService.class, key);
        this.assertBindingAnnotation(Named.class, key);
    }

    @Test
    public void testTypeAndBindingAnnotationExecutor() throws Exception {
        Method method = this.getMethod("methodWithBindingAndType");
        Key key = Keys.getExecutorKey((Method)method);
        this.assertType(ScheduledExecutorService.class, key);
        this.assertBindingAnnotation(Named.class, key);
    }

    @Test
    public void testTypeAndBindingAnnotationScheduler() throws Exception {
        Method method = this.getMethod("methodWithBindingAndType");
        Key key = Keys.getSchedulerKey((Method)method);
        this.assertType(ScheduledExecutorService.class, key);
        this.assertBindingAnnotation(Named.class, key);
    }

    @Test
    public void testTypeOnlyExecutor() throws Exception {
        Method method = this.getMethod("methodWithExecutorOnly");
        Key key = Keys.getExecutorKey((Method)method);
        this.assertType(ScheduledExecutorService.class, key);
        this.assertBindingAnnotation(null, key);
    }

    @Test
    public void testTypeOnlyScheduler() throws Exception {
        Method method = this.getMethod("methodWithExecutorOnly");
        Key key = Keys.getSchedulerKey((Method)method);
        this.assertType(ScheduledExecutorService.class, key);
        this.assertBindingAnnotation(null, key);
    }

    @Test
    public void testPrivateCtor() throws Exception {
        Constructor ctor = Keys.class.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        ctor.newInstance(new Object[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(ctor.getModifiers()));
    }
}

