/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.internal.runnables.InvocationCallable;
import de.skuzzle.inject.async.util.Futures;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InvocationCallableTest {
    @Mock
    private MethodInvocation invocation;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testProceed() throws Throwable {
        String expected = "result";
        Object[] args = new Object[]{};
        Mockito.when((Object)this.invocation.proceed()).thenReturn((Object)Futures.delegate((Object)"result"));
        Mockito.when((Object)this.invocation.getArguments()).thenReturn((Object)args);
        InvocationCallable callable = InvocationCallable.fromInvocation((MethodInvocation)this.invocation);
        Object result = callable.call();
        Assert.assertEquals((Object)"result", result);
    }

    @Test(expected=RuntimeException.class)
    public void testThrowable() throws Throwable {
        ((MethodInvocation)Mockito.doThrow(Throwable.class).when((Object)this.invocation)).proceed();
        InvocationCallable callable = InvocationCallable.fromInvocation((MethodInvocation)this.invocation);
        callable.call();
    }

    @Test(expected=Exception.class)
    public void testException() throws Throwable {
        ((MethodInvocation)Mockito.doThrow(Exception.class).when((Object)this.invocation)).proceed();
        InvocationCallable callable = InvocationCallable.fromInvocation((MethodInvocation)this.invocation);
        callable.call();
    }

    @Test
    public void testPrivateCtor() throws Exception {
        Constructor ctor = GuiceAsync.class.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        ctor.newInstance(new Object[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(ctor.getModifiers()));
    }

    @Test(expected=IllegalStateException.class)
    public void testUnsupportedType() throws Throwable {
        Object[] args = new Object[]{};
        Mockito.when((Object)this.invocation.proceed()).thenReturn(new Object());
        Mockito.when((Object)this.invocation.getArguments()).thenReturn((Object)args);
        InvocationCallable callable = InvocationCallable.fromInvocation((MethodInvocation)this.invocation);
        callable.call();
    }
}

